/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import java.util.ArrayList;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.jt400.Jt400PgmCallException;
import org.apache.camel.component.jt400.Jt400PgmEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jt400PgmProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Jt400PgmProducer.class);

    public Jt400PgmProducer(Jt400PgmEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    private Jt400PgmEndpoint getISeriesEndpoint() {
        return (Jt400PgmEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        AS400 iSeries = this.getISeriesEndpoint().getiSeries();
        String commandStr = this.getISeriesEndpoint().getProgramToExecute();
        ProgramParameter[] parameterList = this.getParameterList(exchange);
        ProgramCall pgmCall = new ProgramCall(iSeries);
        pgmCall.setProgram(commandStr);
        pgmCall.setParameterList(parameterList);
        if (LOG.isDebugEnabled()) {
            LOG.trace("Starting to call PGM '" + commandStr + "' in host '" + iSeries.getSystemName() + "' authentication with the user '" + iSeries.getUserId() + "'");
        }
        boolean result = pgmCall.run();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executed PGM '" + commandStr + "' in host '" + iSeries.getSystemName() + "'. Success? " + result);
        }
        if (!result) {
            throw new Jt400PgmCallException(this.getOutputMessages(pgmCall));
        }
        this.handlePGMOutput(exchange, pgmCall, parameterList);
    }

    private ProgramParameter[] getParameterList(Exchange exchange) throws InvalidPayloadException {
        Object body = ExchangeHelper.getMandatoryInBody((Exchange)exchange);
        String[] params = (String[])body;
        ProgramParameter[] parameterList = new ProgramParameter[params.length];
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            boolean input = param != null;
            boolean output = this.getISeriesEndpoint().isFieldIdxForOuput(i);
            byte[] inputData = null;
            int outputLength = -1;
            if (input) {
                String value = param;
                inputData = new AS400Text(value.length()).toBytes((Object)value);
            }
            if (output) {
                outputLength = this.getISeriesEndpoint().getOutputFieldLength(i);
            }
            if (input && output) {
                parameterList[i] = new ProgramParameter(inputData, outputLength);
            }
            if (input) {
                parameterList[i] = new ProgramParameter(inputData);
            }
            if (!output) continue;
            parameterList[i] = new ProgramParameter(outputLength);
        }
        return parameterList;
    }

    private void handlePGMOutput(Exchange exchange, ProgramCall pgmCall, ProgramParameter[] inputs) throws InvalidPayloadException {
        Object bodyIN = ExchangeHelper.getMandatoryInBody((Exchange)exchange);
        String[] params = (String[])bodyIN;
        ArrayList<String> results = new ArrayList<String>();
        int i = 1;
        for (ProgramParameter pgmParam : pgmCall.getParameterList()) {
            byte[] output = pgmParam.getOutputData();
            String value = params[i - 1];
            if (output != null) {
                int length = pgmParam.getOutputDataLength();
                AS400Text text = new AS400Text(length);
                value = (String)text.toObject(output);
            }
            results.add(value);
            ++i;
        }
        String[] bodyOUT = new String[results.size()];
        bodyOUT = results.toArray(bodyOUT);
        exchange.getOut().setBody((Object)bodyOUT);
    }

    private String getOutputMessages(ProgramCall pgmCall) throws Exception {
        StringBuilder outputMsg = new StringBuilder();
        AS400Message[] messageList = pgmCall.getMessageList();
        for (int i = 0; i < messageList.length; ++i) {
            messageList[i].load();
            outputMsg.append(i + ") ");
            outputMsg.append(messageList[i].getText());
            outputMsg.append(" - ");
            outputMsg.append(messageList[i].getHelp());
            outputMsg.append("\n");
        }
        return outputMsg.toString();
    }
}

