/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.BaseDataQueue;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.KeyedDataQueue;
import org.apache.camel.Service;
import org.apache.camel.component.jt400.Jt400Endpoint;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Jt400DataQueueService
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(Jt400DataQueueService.class);
    private final Jt400Endpoint endpoint;
    private BaseDataQueue queue;

    Jt400DataQueueService(Jt400Endpoint endpoint) {
        ObjectHelper.notNull((Object)((Object)endpoint), (String)"endpoint", (Object)this);
        this.endpoint = endpoint;
    }

    public void start() throws Exception {
        if (this.queue == null) {
            AS400 system = this.endpoint.getSystem();
            this.queue = this.endpoint.isKeyed() ? new KeyedDataQueue(system, this.endpoint.getObjectPath()) : new DataQueue(system, this.endpoint.getObjectPath());
        }
        if (!this.queue.getSystem().isConnected(3)) {
            LOG.info("Connecting to {}", (Object)this.endpoint);
            this.queue.getSystem().connectService(3);
        }
    }

    public void stop() throws Exception {
        if (this.queue != null) {
            LOG.info("Releasing connection to {}", (Object)this.endpoint);
            AS400 system = this.queue.getSystem();
            this.queue = null;
            this.endpoint.releaseSystem(system);
        }
    }

    public BaseDataQueue getDataQueue() {
        return this.queue;
    }
}

