/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.BaseDataQueue;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.DataQueueEntry;
import com.ibm.as400.access.KeyedDataQueue;
import com.ibm.as400.access.KeyedDataQueueEntry;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jt400.Jt400Configuration;
import org.apache.camel.component.jt400.Jt400DataQueueService;
import org.apache.camel.component.jt400.Jt400Endpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.PollingConsumerSupport;

public class Jt400DataQueueConsumer
extends PollingConsumerSupport {
    private final Jt400Endpoint endpoint;
    private final Jt400DataQueueService queueService;

    protected Jt400DataQueueConsumer(Jt400Endpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.queueService = new Jt400DataQueueService(endpoint);
    }

    protected void doStart() throws Exception {
        this.queueService.start();
    }

    protected void doStop() throws Exception {
        this.queueService.stop();
    }

    public Exchange receive() {
        return this.receive(-1L);
    }

    public Exchange receiveNoWait() {
        return this.receive(0L);
    }

    public Exchange receive(long timeout) {
        BaseDataQueue queue = this.queueService.getDataQueue();
        try {
            if (this.endpoint.isKeyed()) {
                return this.receive((KeyedDataQueue)queue, timeout);
            }
            return this.receive((DataQueue)queue, timeout);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Unable to read from data queue: " + queue.getName(), (Throwable)e);
        }
    }

    private Exchange receive(DataQueue queue, long timeout) throws Exception {
        DataQueueEntry entry;
        if (timeout >= 0L) {
            int seconds = (int)timeout / 1000;
            this.log.trace("Reading from data queue: {} with {} seconds timeout", (Object)queue.getName(), (Object)seconds);
            entry = queue.read(seconds);
        } else {
            this.log.trace("Reading from data queue: {} with no timeout", (Object)queue.getName());
            entry = queue.read(-1);
        }
        DefaultExchange exchange = new DefaultExchange(this.endpoint.getCamelContext());
        if (entry != null) {
            exchange.getIn().setHeader("SENDER_INFORMATION", (Object)entry.getSenderInformation());
            if (this.endpoint.getFormat() == Jt400Configuration.Format.binary) {
                exchange.getIn().setBody((Object)entry.getData());
            } else {
                exchange.getIn().setBody((Object)entry.getString());
            }
            return exchange;
        }
        return null;
    }

    private Exchange receive(KeyedDataQueue queue, long timeout) throws Exception {
        KeyedDataQueueEntry entry;
        String key = this.endpoint.getSearchKey();
        String searchType = this.endpoint.getSearchType().name();
        if (timeout >= 0L) {
            int seconds = (int)timeout / 1000;
            this.log.trace("Reading from data queue: {} with {} seconds timeout", (Object)queue.getName(), (Object)seconds);
            entry = queue.read(key, seconds, searchType);
        } else {
            this.log.trace("Reading from data queue: {} with no timeout", (Object)queue.getName());
            entry = queue.read(key, -1, searchType);
        }
        DefaultExchange exchange = new DefaultExchange(this.endpoint.getCamelContext());
        if (entry != null) {
            exchange.getIn().setHeader("SENDER_INFORMATION", (Object)entry.getSenderInformation());
            if (this.endpoint.getFormat() == Jt400Configuration.Format.binary) {
                exchange.getIn().setBody((Object)entry.getData());
                exchange.getIn().setHeader("KEY", (Object)entry.getKey());
            } else {
                exchange.getIn().setBody((Object)entry.getString());
                exchange.getIn().setHeader("KEY", (Object)entry.getKeyString());
            }
            return exchange;
        }
        return null;
    }
}

