/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ConnectionPool;
import com.ibm.as400.access.BaseDataQueue;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.KeyedDataQueue;
import java.beans.PropertyVetoException;
import java.net.URISyntaxException;
import org.apache.camel.CamelException;
import org.apache.camel.Component;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Producer;
import org.apache.camel.component.jt400.Jt400Component;
import org.apache.camel.component.jt400.Jt400DataQueueConsumer;
import org.apache.camel.component.jt400.Jt400DataQueueProducer;
import org.apache.camel.component.jt400.Jt400Endpoint;
import org.apache.camel.impl.DefaultPollingEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class Jt400DataQueueEndpoint
extends DefaultPollingEndpoint {
    public static final String KEY = "KEY";
    public static final String SENDER_INFORMATION = "SENDER_INFORMATION";
    private final Jt400Endpoint baseEndpoint;
    @Deprecated
    private BaseDataQueue dataQueue;
    private boolean keyed;
    private String searchKey;
    private SearchType searchType = SearchType.EQ;

    protected Jt400DataQueueEndpoint(String endpointUri, Jt400Component component) throws CamelException {
        this(endpointUri, component, component.getConnectionPool());
    }

    protected Jt400DataQueueEndpoint(String endpointUri, Jt400Component component, AS400ConnectionPool connectionPool) throws CamelException {
        super(endpointUri, (Component)component);
        ObjectHelper.notNull((Object)connectionPool, (String)"connectionPool");
        try {
            this.baseEndpoint = new Jt400Endpoint(endpointUri, connectionPool);
        }
        catch (URISyntaxException e) {
            throw new CamelException("Unable to parse URI for " + URISupport.sanitizeUri((String)endpointUri), (Throwable)e);
        }
    }

    public void setCcsid(int ccsid) throws PropertyVetoException {
        this.baseEndpoint.setCcsid(ccsid);
    }

    public void setFormat(Format format) {
        this.baseEndpoint.setFormat(format);
    }

    public Format getFormat() {
        return this.baseEndpoint.getFormat();
    }

    public void setKeyed(boolean keyed) {
        this.keyed = keyed;
    }

    public boolean isKeyed() {
        return this.keyed;
    }

    public void setSearchKey(String searchKey) {
        this.searchKey = searchKey;
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public void setSearchType(SearchType searchType) {
        this.searchType = searchType;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public void setGuiAvailable(boolean guiAvailable) throws PropertyVetoException {
        this.baseEndpoint.setGuiAvailable(guiAvailable);
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        return new Jt400DataQueueConsumer(this);
    }

    public Producer createProducer() throws Exception {
        return new Jt400DataQueueProducer(this);
    }

    protected AS400 getSystem() {
        return this.baseEndpoint.getConnection();
    }

    protected void releaseSystem(AS400 system) {
        this.baseEndpoint.releaseConnection(system);
    }

    @Deprecated
    protected BaseDataQueue getDataQueue() {
        if (this.dataQueue == null) {
            AS400 system = new AS400(this.baseEndpoint.getSystemName(), this.baseEndpoint.getUserID(), this.baseEndpoint.getPassword());
            String objectPath = this.baseEndpoint.getObjectPath();
            this.dataQueue = this.keyed ? new KeyedDataQueue(system, objectPath) : new DataQueue(system, objectPath);
        }
        return this.dataQueue;
    }

    protected String getObjectPath() {
        return this.baseEndpoint.getObjectPath();
    }

    public boolean isSingleton() {
        return false;
    }

    public static enum Format {
        text,
        binary;

    }

    public static enum SearchType {
        EQ,
        NE,
        LT,
        LE,
        GT,
        GE;

    }
}

