/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ConnectionPool;
import java.beans.PropertyVetoException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jt400.Jt400Component;
import org.apache.camel.component.jt400.Jt400DataQueueEndpoint;
import org.apache.camel.component.jt400.Jt400Endpoint;
import org.apache.camel.component.jt400.Jt400PgmProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;

public class Jt400PgmEndpoint
extends DefaultEndpoint {
    private final Jt400Endpoint baseEndpoint;
    private Integer[] outputFieldsIdxArray;
    private Integer[] outputFieldsLengthArray;

    protected Jt400PgmEndpoint(String endpointUri, Jt400Component component) throws CamelException {
        this(endpointUri, component, component.getConnectionPool());
    }

    protected Jt400PgmEndpoint(String endpointUri, Jt400Component component, AS400ConnectionPool connectionPool) throws CamelException {
        super(endpointUri, (Component)component);
        ObjectHelper.notNull((Object)connectionPool, (String)"connectionPool");
        try {
            this.baseEndpoint = new Jt400Endpoint(endpointUri, connectionPool);
        }
        catch (URISyntaxException e) {
            throw new CamelException("Unable to parse URI for " + endpointUri, (Throwable)e);
        }
    }

    public Jt400PgmEndpoint(String endpointUri, String programToExecute, Map<String, Object> parameters, CamelContext camelContext) {
        super(endpointUri, camelContext);
        ObjectHelper.notNull(parameters, (String)"parameters", (Object)((Object)this));
        if (!parameters.containsKey("connectionPool")) {
            throw new RuntimeCamelException(String.format("parameters must specify '%s'", "connectionPool"));
        }
        String poolId = parameters.get("connectionPool").toString();
        AS400ConnectionPool connectionPool = (AS400ConnectionPool)EndpointHelper.resolveReferenceParameter((CamelContext)camelContext, (String)poolId, AS400ConnectionPool.class, (boolean)true);
        try {
            this.baseEndpoint = new Jt400Endpoint(endpointUri, connectionPool);
        }
        catch (URISyntaxException e) {
            throw new RuntimeCamelException("Unable to parse URI for " + endpointUri, (Throwable)e);
        }
    }

    public Producer createProducer() throws Exception {
        return new Jt400PgmProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new OperationNotSupportedException();
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isFieldIdxForOuput(int idx) {
        return Arrays.binarySearch((Object[])this.outputFieldsIdxArray, (Object)idx) >= 0;
    }

    public int getOutputFieldLength(int idx) {
        return this.outputFieldsLengthArray[idx];
    }

    public String getProgramToExecute() {
        return this.baseEndpoint.getObjectPath();
    }

    public AS400 getiSeries() {
        return this.baseEndpoint.getConnection();
    }

    public void releaseiSeries(AS400 iSeries) {
        this.baseEndpoint.releaseConnection(iSeries);
    }

    public void setOutputFieldsIdx(String outputFieldsIdx) {
        if (outputFieldsIdx != null) {
            String[] outputArray = outputFieldsIdx.split(",");
            this.outputFieldsIdxArray = new Integer[outputArray.length];
            for (int i = 0; i < outputArray.length; ++i) {
                String str = outputArray[i];
                this.outputFieldsIdxArray[i] = Integer.parseInt(str);
            }
        }
    }

    public void setFieldsLength(String fieldsLength) {
        if (fieldsLength != null) {
            String[] outputArray = fieldsLength.split(",");
            this.outputFieldsLengthArray = new Integer[outputArray.length];
            for (int i = 0; i < outputArray.length; ++i) {
                String str = outputArray[i];
                this.outputFieldsLengthArray[i] = Integer.parseInt(str);
            }
        }
    }

    public void setFormat(Jt400DataQueueEndpoint.Format format) {
        this.baseEndpoint.setFormat(format);
    }

    public Jt400DataQueueEndpoint.Format getFormat() {
        return this.baseEndpoint.getFormat();
    }

    public void setGuiAvailable(boolean guiAvailable) throws PropertyVetoException {
        this.baseEndpoint.setGuiAvailable(guiAvailable);
    }

    public boolean isGuiAvailable() {
        return this.baseEndpoint.isGuiAvailable();
    }
}

