/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.jsonpath.JsonPathAdapter;
import org.apache.camel.spi.Registry;

public class JacksonJsonAdapter
implements JsonPathAdapter {
    private static final String JACKSON_JAXB_MODULE = "com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule";
    private final ObjectMapper defaultMapper = new ObjectMapper();

    @Override
    public void init(CamelContext camelContext) {
        Object obj;
        Class clazz = camelContext.getClassResolver().resolveClass(JACKSON_JAXB_MODULE);
        if (clazz != null && (obj = camelContext.getInjector().newInstance(clazz)) instanceof Module) {
            Module module = (Module)obj;
            this.defaultMapper.registerModule(module);
        }
    }

    @Override
    public Map readValue(Object body, Exchange exchange) {
        ObjectMapper mapper = this.resolveObjectMapper(exchange.getContext().getRegistry());
        try {
            return (Map)mapper.convertValue(body, Map.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String writeAsString(Object value, Exchange exchange) {
        ObjectMapper mapper = this.resolveObjectMapper(exchange.getContext().getRegistry());
        try {
            return mapper.writeValueAsString(value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ObjectMapper resolveObjectMapper(Registry registry) {
        Set mappers = registry.findByType(ObjectMapper.class);
        if (mappers.size() == 1) {
            return (ObjectMapper)mappers.iterator().next();
        }
        return this.defaultMapper;
    }
}

