/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.DefaultsImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.jsonpath.JsonStream;

public class JsonPathEngine {
    private final JsonPath path;
    private final Configuration configuration;

    public JsonPathEngine(String expression) {
        this(expression, false, null);
    }

    public JsonPathEngine(String expression, boolean suppressExceptions, Option[] options) {
        DefaultsImpl defaults = DefaultsImpl.INSTANCE;
        if (options != null) {
            Configuration.ConfigurationBuilder builder = Configuration.builder().jsonProvider(defaults.jsonProvider()).options(options);
            if (suppressExceptions) {
                builder.options(new Option[]{Option.SUPPRESS_EXCEPTIONS});
            }
            this.configuration = builder.build();
        } else {
            Configuration.ConfigurationBuilder builder = Configuration.builder().jsonProvider(defaults.jsonProvider());
            if (suppressExceptions) {
                builder.options(new Option[]{Option.SUPPRESS_EXCEPTIONS});
            }
            this.configuration = builder.build();
        }
        this.path = JsonPath.compile((String)expression, (Predicate[])new Predicate[0]);
    }

    public Object read(Exchange exchange) throws IOException, InvalidPayloadException {
        GenericFile genericFile;
        Object json = exchange.getIn().getBody();
        if (json instanceof GenericFile && (genericFile = (GenericFile)json).getCharset() != null) {
            FileInputStream inputStream = new FileInputStream((File)genericFile.getFile());
            return this.path.read((InputStream)inputStream, genericFile.getCharset(), this.configuration);
        }
        if (json instanceof String) {
            String str = (String)json;
            return this.path.read(str, this.configuration);
        }
        InputStream is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
        String jsonEncoding = (String)exchange.getIn().getHeader("CamelJsonPathJsonEncoding", String.class);
        if (jsonEncoding != null) {
            return this.path.read(is, jsonEncoding, this.configuration);
        }
        JsonStream jsonStream = new JsonStream(is);
        return this.path.read((InputStream)jsonStream, jsonStream.getEncoding().name(), this.configuration);
    }
}

