/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.jq;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderOrPropertyException;
import org.apache.camel.NoSuchVariableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.language.jq.JqFunctions;
import org.apache.camel.language.jq.JqLanguage;
import org.apache.camel.spi.ExpressionResultTypeAware;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.MessageHelper;

public class JqExpression
extends ExpressionAdapter
implements ExpressionResultTypeAware {
    private final String expression;
    private Scope scope;
    private String resultTypeName;
    private Class<?> resultType;
    private JsonQuery query;
    private TypeConverter typeConverter;
    private String variableName;
    private String headerName;
    private String propertyName;

    public JqExpression(String expression) {
        this(null, expression);
    }

    public JqExpression(Scope scope, String expression) {
        this.scope = scope;
        this.expression = expression;
    }

    public void init(CamelContext camelContext) {
        if (this.query == null) {
            super.init(camelContext);
            if (this.scope == null) {
                JqLanguage lan = (JqLanguage)camelContext.resolveLanguage("jq");
                this.scope = Scope.newChildScope((Scope)lan.getRootScope());
            }
            this.typeConverter = camelContext.getTypeConverter();
            try {
                this.query = JsonQuery.compile((String)this.expression, (Version)Versions.JQ_1_6);
            }
            catch (JsonQueryException e) {
                throw new ExpressionIllegalSyntaxException(this.expression, (Throwable)e);
            }
            if (this.resultTypeName != null && (this.resultType == null || this.resultType == Object.class)) {
                this.resultType = camelContext.getClassResolver().resolveClass(this.resultTypeName);
            }
            if (this.resultType == null || this.resultType == Object.class) {
                this.resultType = JsonNode.class;
            }
        }
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public String getExpressionText() {
        return this.expression;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public String getResultTypeName() {
        return this.resultTypeName;
    }

    public void setResultTypeName(String resultTypeName) {
        this.resultTypeName = resultTypeName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public boolean matches(Exchange exchange) {
        Object value = this.evaluate(exchange, Object.class);
        if (value instanceof BooleanNode) {
            return ((BooleanNode)value).asBoolean();
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        return false;
    }

    public Object evaluate(Exchange exchange) {
        if (this.query == null) {
            return null;
        }
        try {
            JqFunctions.EXCHANGE_LOCAL.set(exchange);
            ArrayList outputs = new ArrayList(1);
            JsonNode payload = this.getPayload(exchange);
            this.query.apply(this.scope, payload, outputs::add);
            if (outputs.size() == 1) {
                if (this.resultType == JsonNode.class) {
                    Object e = outputs.get(0);
                    return e;
                }
                Object object = this.typeConverter.convertTo(this.resultType, exchange, outputs.get(0));
                return object;
            }
            if (outputs.size() > 1) {
                if (this.resultType == JsonNode.class) {
                    ArrayList arrayList = outputs;
                    return arrayList;
                }
                List list = outputs.stream().map(item -> this.typeConverter.convertTo(this.resultType, exchange, item)).collect(Collectors.toList());
                return list;
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        finally {
            JqFunctions.EXCHANGE_LOCAL.remove();
        }
        return null;
    }

    private JsonNode getPayload(Exchange exchange) throws Exception {
        JsonNode payload = null;
        if (this.variableName == null && this.headerName == null && this.propertyName == null) {
            payload = (JsonNode)exchange.getMessage().getBody(JsonNode.class);
            if (payload == null) {
                throw new InvalidPayloadException(exchange, JsonNode.class);
            }
            MessageHelper.resetStreamCache((Message)exchange.getMessage());
        } else {
            if (this.variableName != null && (payload = (JsonNode)ExchangeHelper.getVariable((Exchange)exchange, (String)this.variableName, JsonNode.class)) == null) {
                throw new NoSuchVariableException(exchange, this.variableName, JsonNode.class);
            }
            if (payload == null && this.headerName != null) {
                payload = (JsonNode)exchange.getMessage().getHeader(this.headerName, JsonNode.class);
            }
            if (payload == null && this.propertyName != null) {
                payload = (JsonNode)exchange.getProperty(this.propertyName, JsonNode.class);
            }
            if (payload == null) {
                throw new NoSuchHeaderOrPropertyException(exchange, this.headerName, this.propertyName, JsonNode.class);
            }
        }
        return payload;
    }
}

