/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.component.jpa.JpaHelper;
import org.apache.camel.component.jpa.QueryBuilder;
import org.apache.camel.component.jpa.QueryFactory;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.apache.camel.support.PollingConsumerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaPollingConsumer
extends PollingConsumerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JpaPollingConsumer.class);
    private volatile ExecutorService executorService;
    private final EntityManagerFactory entityManagerFactory;
    private final TransactionStrategy transactionStrategy;
    private String query;
    private String namedQuery;
    private String nativeQuery;
    private LockModeType lockModeType = LockModeType.PESSIMISTIC_WRITE;
    private Class<?> resultClass;
    private QueryFactory queryFactory;
    private Map<String, Object> parameters;

    public JpaPollingConsumer(JpaEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.entityManagerFactory = endpoint.getEntityManagerFactory();
        this.transactionStrategy = endpoint.getTransactionStrategy();
    }

    public JpaEndpoint getEndpoint() {
        return (JpaEndpoint)super.getEndpoint();
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getNamedQuery() {
        return this.namedQuery;
    }

    public void setNamedQuery(String namedQuery) {
        this.namedQuery = namedQuery;
    }

    public String getNativeQuery() {
        return this.nativeQuery;
    }

    public void setNativeQuery(String nativeQuery) {
        this.nativeQuery = nativeQuery;
    }

    public LockModeType getLockModeType() {
        return this.lockModeType;
    }

    public void setLockModeType(LockModeType lockModeType) {
        this.lockModeType = lockModeType;
    }

    public Class<?> getResultClass() {
        return this.resultClass;
    }

    public void setResultClass(Class<?> resultClass) {
        this.resultClass = resultClass;
    }

    public QueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    public void setQueryFactory(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Exchange receive() {
        final EntityManager entityManager = JpaHelper.getTargetEntityManager(null, this.entityManagerFactory, this.getEndpoint().isUsePassedInEntityManager(), this.getEndpoint().isSharedEntityManager(), true);
        final Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setHeader("CamelEntityManager", (Object)entityManager);
        this.transactionStrategy.executeInTransaction(new Runnable(){

            @Override
            public void run() {
                List answer;
                if (JpaPollingConsumer.this.getEndpoint().isJoinTransaction()) {
                    entityManager.joinTransaction();
                }
                Query innerQuery = JpaPollingConsumer.this.getQueryFactory().createQuery(entityManager);
                JpaPollingConsumer.this.configureParameters(innerQuery);
                if (JpaPollingConsumer.this.getEndpoint().isConsumeLockEntity()) {
                    innerQuery.setLockMode(JpaPollingConsumer.this.getLockModeType());
                }
                LOG.trace("Created query {}", (Object)innerQuery);
                try {
                    List results = innerQuery.getResultList();
                    answer = results != null && results.size() == 1 ? results.get(0) : results;
                    LOG.debug("Flushing EntityManager");
                    entityManager.flush();
                    entityManager.clear();
                }
                catch (PersistenceException e) {
                    LOG.info("Disposing EntityManager {} on {} due to coming transaction rollback", (Object)entityManager, (Object)this);
                    entityManager.close();
                    throw e;
                }
                exchange.getIn().setBody((Object)answer);
            }
        });
        return exchange;
    }

    public Exchange receiveNoWait() {
        return this.receive();
    }

    public Exchange receive(long timeout) {
        if (this.executorService == null) {
            this.executorService = this.getEndpoint().getComponent().getOrCreatePollingConsumerExecutorService();
        }
        Future<Exchange> future = this.executorService.submit(this::receive);
        try {
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        catch (TimeoutException timeoutException) {
            return null;
        }
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.queryFactory == null) {
            this.queryFactory = this.createQueryFactory();
            if (this.queryFactory == null) {
                throw new IllegalArgumentException("No queryType property configured on this consumer, nor an entityType configured on the endpoint so cannot consume");
            }
        }
    }

    protected void doStop() throws Exception {
    }

    protected void configureParameters(Query query) {
        int maxResults = this.getEndpoint().getMaximumResults();
        if (maxResults > 0) {
            query.setMaxResults(maxResults);
        }
        if (this.parameters != null) {
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                query.setParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    protected Exchange createExchange(Object result, EntityManager entityManager) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody(result);
        exchange.getIn().setHeader("CamelEntityManager", (Object)entityManager);
        return exchange;
    }

    protected QueryFactory createQueryFactory() {
        if (this.query != null) {
            return QueryBuilder.query(this.query);
        }
        if (this.namedQuery != null) {
            return QueryBuilder.namedQuery(this.namedQuery);
        }
        if (this.nativeQuery != null) {
            if (this.resultClass != null) {
                return QueryBuilder.nativeQuery(this.nativeQuery, this.resultClass);
            }
            return QueryBuilder.nativeQuery(this.nativeQuery);
        }
        Class<?> entityType = this.getEndpoint().getEntityType();
        if (entityType == null) {
            return null;
        }
        String name = this.getEntityName(entityType);
        if (name != null) {
            return QueryBuilder.query("select x from " + name + " x");
        }
        return QueryBuilder.query("select x from " + entityType.getSimpleName() + " x");
    }

    protected String getEntityName(Class<?> clazz) {
        Entity entity = clazz.getAnnotation(Entity.class);
        if (entity != null && !entity.name().isEmpty()) {
            return entity.name();
        }
        return null;
    }
}

