/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.jpa.JpaCloseEntityManagerOnCompletion;
import org.apache.camel.spi.Synchronization;
import org.springframework.orm.jpa.SharedEntityManagerCreator;

public final class JpaHelper {
    private JpaHelper() {
    }

    public static EntityManager getTargetEntityManager(Exchange exchange, EntityManagerFactory entityManagerFactory, boolean usePassedInEntityManager, boolean useSharedEntityManager, boolean allowRecreate) {
        Map<String, Object> data;
        EntityManager em = null;
        if (exchange != null && usePassedInEntityManager) {
            em = (EntityManager)exchange.getIn().getHeader("CamelEntityManager", EntityManager.class);
        }
        if (em == null && exchange != null) {
            em = JpaHelper.getEntityManagerMap(exchange).get(JpaHelper.getKey(entityManagerFactory));
        }
        if (em == null && exchange != null && exchange.isTransacted() && (data = JpaHelper.getTransactionContextData(exchange)) != null) {
            em = (EntityManager)data.get(JpaHelper.getKey(entityManagerFactory));
        }
        if (em == null && useSharedEntityManager) {
            em = SharedEntityManagerCreator.createSharedEntityManager((EntityManagerFactory)entityManagerFactory);
        }
        if (em == null) {
            em = JpaHelper.createEntityManager(exchange, entityManagerFactory);
        }
        if (allowRecreate && em == null || !em.isOpen()) {
            em = JpaHelper.createEntityManager(exchange, entityManagerFactory);
        }
        return em;
    }

    public static void copyEntityManagers(Exchange target, Exchange source) {
        Map entityManagers;
        if (target != null && source != null && target.getProperty("CamelEntityManager") == null && (entityManagers = (Map)source.getProperty("CamelEntityManager", Map.class)) != null) {
            target.setProperty("CamelEntityManager", (Object)entityManagers);
        }
    }

    private static EntityManager createEntityManager(Exchange exchange, EntityManagerFactory entityManagerFactory) {
        EntityManager em = entityManagerFactory.createEntityManager();
        if (exchange != null) {
            Map<String, Object> data;
            Map<String, EntityManager> entityManagers = JpaHelper.getEntityManagerMap(exchange);
            entityManagers.put(JpaHelper.getKey(entityManagerFactory), em);
            if (exchange.isTransacted() && (data = JpaHelper.getTransactionContextData(exchange)) != null) {
                data.put(JpaHelper.getKey(entityManagerFactory), em);
            }
            exchange.getExchangeExtension().addOnCompletion((Synchronization)new JpaCloseEntityManagerOnCompletion(em));
        }
        return em;
    }

    private static Map<String, Object> getTransactionContextData(Exchange exchange) {
        Map data = null;
        if (exchange.isTransacted()) {
            data = (Map)exchange.getProperty("CamelTransactionContextData", Map.class);
        }
        return data;
    }

    private static Map<String, EntityManager> getEntityManagerMap(Exchange exchange) {
        HashMap entityManagers = (HashMap)exchange.getProperty("CamelEntityManager", Map.class);
        if (entityManagers == null) {
            entityManagers = new HashMap();
            exchange.setProperty("CamelEntityManager", entityManagers);
        }
        return entityManagers;
    }

    private static String getKey(EntityManagerFactory entityManagerFactory) {
        return String.valueOf(entityManagerFactory.hashCode());
    }
}

