/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.jpa;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.jpa.DefaultTransactionStrategy;
import org.apache.camel.component.jpa.JpaHelper;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.apache.camel.processor.idempotent.jpa.MessageProcessed;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="JPA based message id repository")
public class JpaMessageIdRepository
extends ServiceSupport
implements IdempotentRepository {
    protected static final String QUERY_STRING = "select x from " + MessageProcessed.class.getName() + " x where x.processorName = ?1 and x.messageId = ?2";
    protected static final String QUERY_CLEAR_STRING = "select x from " + MessageProcessed.class.getName() + " x where x.processorName = ?1";
    private static final String SOMETHING_WENT_WRONG = "Something went wrong trying to add message to repository %s";
    private static final Logger LOG = LoggerFactory.getLogger(JpaMessageIdRepository.class);
    private final String processorName;
    private final EntityManagerFactory entityManagerFactory;
    private final TransactionStrategy transactionStrategy;
    private boolean joinTransaction = true;
    private boolean sharedEntityManager;

    public JpaMessageIdRepository(EntityManagerFactory entityManagerFactory, String processorName) {
        this(entityManagerFactory, JpaMessageIdRepository.createDefaultTransactionStrategy(entityManagerFactory), processorName);
    }

    public JpaMessageIdRepository(EntityManagerFactory entityManagerFactory, TransactionStrategy transactionStrategy, String processorName) {
        this.entityManagerFactory = entityManagerFactory;
        this.processorName = processorName;
        this.transactionStrategy = transactionStrategy;
    }

    public static JpaMessageIdRepository jpaMessageIdRepository(String persistenceUnit, String processorName) {
        return JpaMessageIdRepository.jpaMessageIdRepository(Persistence.createEntityManagerFactory((String)persistenceUnit), processorName);
    }

    public static JpaMessageIdRepository jpaMessageIdRepository(EntityManagerFactory entityManagerFactory, String processorName) {
        return new JpaMessageIdRepository(entityManagerFactory, processorName);
    }

    private static TransactionStrategy createDefaultTransactionStrategy(EntityManagerFactory entityManagerFactory) {
        return new DefaultTransactionStrategy(null, entityManagerFactory);
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String messageId) {
        return this.add(null, messageId);
    }

    public boolean add(Exchange exchange, String messageId) {
        EntityManager entityManager = JpaHelper.getTargetEntityManager(exchange, this.entityManagerFactory, true, this.sharedEntityManager, true);
        Boolean[] rc = new Boolean[1];
        this.transactionStrategy.executeInTransaction(() -> {
            if (this.isJoinTransaction()) {
                entityManager.joinTransaction();
            }
            try {
                List<?> list = this.query(entityManager, messageId);
                if (list.isEmpty()) {
                    MessageProcessed processed = new MessageProcessed();
                    processed.setProcessorName(this.processorName);
                    processed.setMessageId(messageId);
                    processed.setCreatedAt(new Date());
                    entityManager.persist((Object)processed);
                    entityManager.flush();
                    entityManager.close();
                    rc[0] = Boolean.TRUE;
                } else {
                    rc[0] = Boolean.FALSE;
                }
            }
            catch (Exception ex) {
                String contextInfo = String.format(SOMETHING_WENT_WRONG, ex.getMessage());
                throw new PersistenceException(contextInfo, (Throwable)ex);
            }
            finally {
                try {
                    if (entityManager.isOpen()) {
                        entityManager.close();
                    }
                }
                catch (Exception exception) {}
            }
        });
        LOG.debug("add {} -> {}", (Object)messageId, (Object)rc[0]);
        return rc[0];
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String messageId) {
        return this.contains(null, messageId);
    }

    public boolean contains(Exchange exchange, String messageId) {
        EntityManager entityManager = JpaHelper.getTargetEntityManager(exchange, this.entityManagerFactory, true, this.sharedEntityManager, true);
        Boolean[] rc = new Boolean[1];
        this.transactionStrategy.executeInTransaction(() -> {
            if (this.isJoinTransaction()) {
                entityManager.joinTransaction();
            }
            try {
                List<?> list = this.query(entityManager, messageId);
                rc[0] = list.isEmpty() ? Boolean.FALSE : Boolean.TRUE;
            }
            catch (Exception ex) {
                String contextInfo = String.format(SOMETHING_WENT_WRONG, ex.getMessage());
                throw new PersistenceException(contextInfo, (Throwable)ex);
            }
            finally {
                try {
                    if (entityManager.isOpen()) {
                        entityManager.close();
                    }
                }
                catch (Exception exception) {}
            }
        });
        LOG.debug("contains {} -> {}", (Object)messageId, (Object)rc[0]);
        return rc[0];
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String messageId) {
        return this.remove(null, messageId);
    }

    public boolean remove(Exchange exchange, String messageId) {
        EntityManager entityManager = JpaHelper.getTargetEntityManager(exchange, this.entityManagerFactory, true, this.sharedEntityManager, true);
        Boolean[] rc = new Boolean[1];
        this.transactionStrategy.executeInTransaction(() -> {
            if (this.isJoinTransaction()) {
                entityManager.joinTransaction();
            }
            try {
                List<?> list = this.query(entityManager, messageId);
                if (list.isEmpty()) {
                    rc[0] = Boolean.FALSE;
                } else {
                    MessageProcessed processed = (MessageProcessed)list.get(0);
                    entityManager.remove((Object)processed);
                    entityManager.flush();
                    entityManager.close();
                    rc[0] = Boolean.TRUE;
                }
            }
            catch (Exception ex) {
                String contextInfo = String.format(SOMETHING_WENT_WRONG, ex.getMessage());
                throw new PersistenceException(contextInfo, (Throwable)ex);
            }
            finally {
                try {
                    if (entityManager.isOpen()) {
                        entityManager.close();
                    }
                }
                catch (Exception exception) {}
            }
        });
        LOG.debug("remove {}", (Object)messageId);
        return rc[0];
    }

    public boolean confirm(String messageId) {
        return this.confirm(null, messageId);
    }

    public boolean confirm(Exchange exchange, String messageId) {
        LOG.debug("confirm {} -> true", (Object)messageId);
        return true;
    }

    @ManagedOperation(description="Clear the store")
    public void clear() {
        EntityManager entityManager = JpaHelper.getTargetEntityManager(null, this.entityManagerFactory, true, this.sharedEntityManager, true);
        this.transactionStrategy.executeInTransaction(() -> {
            if (this.isJoinTransaction()) {
                entityManager.joinTransaction();
            }
            try {
                List<?> list = this.queryClear(entityManager);
                if (!list.isEmpty()) {
                    for (Object item : list) {
                        entityManager.remove(item);
                    }
                    entityManager.flush();
                    entityManager.close();
                }
            }
            catch (Exception ex) {
                String contextInfo = String.format(SOMETHING_WENT_WRONG, ex.getMessage());
                throw new PersistenceException(contextInfo, (Throwable)ex);
            }
            finally {
                try {
                    if (entityManager.isOpen()) {
                        entityManager.close();
                    }
                }
                catch (Exception exception) {}
            }
        });
        LOG.debug("clear the store {}", (Object)MessageProcessed.class.getName());
    }

    private List<?> query(EntityManager entityManager, String messageId) {
        Query query = entityManager.createQuery(QUERY_STRING);
        query.setParameter(1, (Object)this.processorName);
        query.setParameter(2, (Object)messageId);
        return query.getResultList();
    }

    private List<?> queryClear(EntityManager entityManager) {
        Query query = entityManager.createQuery(QUERY_CLEAR_STRING);
        query.setParameter(1, (Object)this.processorName);
        return query.getResultList();
    }

    @ManagedAttribute(description="The processor name")
    public String getProcessorName() {
        return this.processorName;
    }

    @ManagedAttribute(description="Whether to join existing transaction")
    public boolean isJoinTransaction() {
        return this.joinTransaction;
    }

    public void setJoinTransaction(boolean joinTransaction) {
        this.joinTransaction = joinTransaction;
    }

    @ManagedAttribute(description="Whether to use shared EntityManager")
    public boolean isSharedEntityManager() {
        return this.sharedEntityManager;
    }

    public void setSharedEntityManager(boolean sharedEntityManager) {
        this.sharedEntityManager = sharedEntityManager;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

