/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.joor;

import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.Message;

public final class JoorHelper {
    private JoorHelper() {
    }

    public static <T> T bodyAs(Message message, Class<T> type) {
        return (T)message.getBody(type);
    }

    public static <T> Optional<T> optionalBodyAs(Message message, Class<T> type) {
        return Optional.ofNullable(message.getBody(type));
    }

    public static <T> T headerAs(Message message, String name, Class<T> type) {
        return (T)message.getHeader(name, type);
    }

    public static <T> T headerAs(Message message, String name, Object defaultValue, Class<T> type) {
        return (T)message.getHeader(name, defaultValue, type);
    }

    public static <T> Optional<T> optionalHeaderAs(Message message, String name, Class<T> type) {
        return Optional.ofNullable(message.getHeader(name, type));
    }

    public static <T> T exchangePropertyAs(Exchange exchange, String name, Class<T> type) {
        return (T)exchange.getProperty(name, type);
    }

    public static <T> T exchangePropertyAs(Exchange exchange, String name, Object defaultValue, Class<T> type) {
        return (T)exchange.getProperty(name, defaultValue, type);
    }

    public static <T> Optional<T> optionalExchangePropertyAs(Exchange exchange, String name, Class<T> type) {
        return Optional.ofNullable(exchange.getProperty(name, type));
    }
}

