/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.joor;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CompilationUnit {
    private final Map<String, String> files = new LinkedHashMap<String, String>();
    private ClassLoader classLoader;

    static Result result() {
        return new Result();
    }

    public static CompilationUnit input() {
        return new CompilationUnit();
    }

    public CompilationUnit addClass(String className, String content) {
        this.files.put(className, content);
        return this;
    }

    public CompilationUnit withClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public Map<String, String> getInput() {
        return this.files;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String toString() {
        String names = String.join((CharSequence)", ", this.files.keySet());
        return "CompilationUnit[" + names + "]";
    }

    public static class Result {
        private final Map<String, Class<?>> classes = new LinkedHashMap();
        private final Map<String, byte[]> compiled = new LinkedHashMap<String, byte[]>();

        void addResult(String className, Class<?> clazz, byte[] byteCode) {
            if (clazz != null && !this.classes.containsKey(className)) {
                this.classes.put(className, clazz);
            }
            if (byteCode != null && !this.compiled.containsKey(className)) {
                this.compiled.put(className, byteCode);
            }
        }

        public Class<?> getClass(String className) {
            return this.classes.get(className);
        }

        public byte[] getByteCode(String className) {
            return this.compiled.get(className);
        }

        public int size() {
            return this.classes.size();
        }

        public Set<String> getClassNames() {
            return this.classes.keySet();
        }

        public Set<String> getCompiledClassNames() {
            return this.compiled.keySet();
        }
    }
}

