/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.joor;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StaticService;
import org.apache.camel.language.joor.JoorCompiler;
import org.apache.camel.language.joor.JoorExpression;
import org.apache.camel.language.joor.JoorScriptingCompiler;
import org.apache.camel.language.joor.JoorScriptingMethod;
import org.apache.camel.spi.ScriptingLanguage;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.support.TypedLanguageSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Language(value="joor")
public class JoorLanguage
extends TypedLanguageSupport
implements ScriptingLanguage,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(JoorLanguage.class);
    private static Boolean java8;
    private final JoorCompiler compiler = new JoorCompiler();
    private final JoorScriptingCompiler scriptingCompiler = new JoorScriptingCompiler();
    private final Set<String> imports = new TreeSet<String>();
    private final Map<String, String> aliases = new HashMap<String, String>();
    private String configResource = "classpath:camel-joor.properties?optional=true";
    private boolean preCompile = true;
    private boolean singleQuotes = true;

    public String getConfigResource() {
        return this.configResource;
    }

    public void setConfigResource(String configResource) {
        this.configResource = configResource;
        this.loadConfiguration();
    }

    public boolean isPreCompile() {
        return this.preCompile;
    }

    public void setPreCompile(boolean preCompile) {
        this.preCompile = preCompile;
    }

    public boolean isSingleQuotes() {
        return this.singleQuotes;
    }

    public void setSingleQuotes(boolean singleQuotes) {
        this.singleQuotes = singleQuotes;
    }

    public <T> T evaluate(String script, Map<String, Object> bindings, Class<T> resultType) {
        Object out;
        JoorScriptingMethod target = this.scriptingCompiler.compile(this.getCamelContext(), script, bindings, this.singleQuotes);
        try {
            out = target.evaluate(bindings);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
        if (out != null && resultType != null) {
            return (T)this.getCamelContext().getTypeConverter().convertTo(resultType, out);
        }
        return (T)out;
    }

    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression));
    }

    public Expression createExpression(String expression) {
        JoorExpression exp = new JoorExpression(expression);
        exp.setCompiler(this.compiler);
        exp.setResultType(this.getResultType());
        exp.setSingleQuotes(this.singleQuotes);
        exp.init(this.getCamelContext());
        return exp;
    }

    public Predicate createPredicate(String expression, Object[] properties) {
        return (JoorExpression)this.createExpression(expression, properties);
    }

    public Expression createExpression(String expression, Object[] properties) {
        JoorExpression exp = new JoorExpression(expression);
        exp.setCompiler(this.compiler);
        exp.setPreCompile((Boolean)this.property(Boolean.TYPE, properties, 0, this.preCompile));
        exp.setResultType((Class)this.property(Class.class, properties, 1, this.getResultType()));
        exp.setSingleQuotes((Boolean)this.property(Boolean.TYPE, properties, 2, this.singleQuotes));
        exp.init(this.getCamelContext());
        return exp;
    }

    public void init() {
        if (java8 == null && (java8 = Boolean.valueOf(JoorLanguage.getJavaMajorVersion() == 8)).booleanValue()) {
            throw new UnsupportedOperationException("Java 8 is not supported. Use Java 11 or higher");
        }
        this.loadConfiguration();
    }

    public void start() {
        ServiceHelper.startService((Object)((Object)this.compiler));
    }

    public void stop() {
        ServiceHelper.stopService((Object)((Object)this.compiler));
    }

    private void loadConfiguration() {
        String loaded = ScriptHelper.resolveOptionalExternalScript((CamelContext)this.getCamelContext(), (String)("resource:" + this.configResource));
        int counter1 = 0;
        int counter2 = 0;
        if (loaded != null) {
            String[] lines;
            for (String line : lines = loaded.split("\n")) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.startsWith("import ")) {
                    this.imports.add(line);
                    ++counter1;
                    continue;
                }
                String key = StringHelper.before((String)line, (String)"=");
                String value = StringHelper.after((String)line, (String)"=");
                if (key != null) {
                    key = key.trim();
                }
                if (value != null) {
                    value = value.trim();
                }
                if (key == null || value == null) continue;
                this.aliases.put(key, value);
                ++counter2;
            }
        }
        if (counter1 > 0 || counter2 > 0) {
            LOG.info("Loaded jOOR language imports: {} and aliases: {} from configuration: {}", new Object[]{counter1, counter2, this.configResource});
        }
        if (this.compiler.getAliases() == null) {
            this.compiler.setAliases(this.aliases);
        } else {
            this.compiler.getAliases().putAll(this.aliases);
        }
        if (this.compiler.getImports() == null) {
            this.compiler.setImports(this.imports);
        } else {
            this.compiler.getImports().addAll(this.imports);
        }
        if (this.scriptingCompiler.getAliases() == null) {
            this.scriptingCompiler.setAliases(this.aliases);
        } else {
            this.scriptingCompiler.getAliases().putAll(this.aliases);
        }
        if (this.scriptingCompiler.getImports() == null) {
            this.scriptingCompiler.setImports(this.imports);
        } else {
            this.scriptingCompiler.getImports().addAll(this.imports);
        }
    }

    private static int getJavaMajorVersion() {
        String javaSpecVersion = System.getProperty("java.specification.version");
        return javaSpecVersion.contains(".") ? Integer.parseInt(javaSpecVersion.split("\\.")[1]) : Integer.parseInt(javaSpecVersion);
    }
}

