/*
 * This file is generated by jOOQ.
 */
package org.apache.camel.component.jooq.db.tables;


import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.apache.camel.component.jooq.db.Indexes;
import org.apache.camel.component.jooq.db.Keys;
import org.apache.camel.component.jooq.db.Public;
import org.apache.camel.component.jooq.db.tables.Author.AuthorPath;
import org.apache.camel.component.jooq.db.tables.BookStore.BookStorePath;
import org.apache.camel.component.jooq.db.tables.BookToBookStore.BookToBookStorePath;
import org.apache.camel.component.jooq.db.tables.records.BookRecord;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.InverseForeignKey;
import org.jooq.Name;
import org.jooq.Path;
import org.jooq.PlainSQL;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQL;
import org.jooq.Schema;
import org.jooq.Select;
import org.jooq.Stringly;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;


/**
 * This class is generated by jOOQ.
 */
@SuppressWarnings({ "all", "unchecked", "rawtypes", "this-escape" })
public class Book extends TableImpl<BookRecord> {

    private static final long serialVersionUID = 1L;

    /**
     * The reference instance of <code>PUBLIC.BOOK</code>
     */
    public static final Book BOOK = new Book();

    /**
     * The class holding records for this type
     */
    @Override
    public Class<BookRecord> getRecordType() {
        return BookRecord.class;
    }

    /**
     * The column <code>PUBLIC.BOOK.ID</code>.
     */
    public final TableField<BookRecord, Integer> ID = createField(DSL.name("ID"), SQLDataType.INTEGER.nullable(false), this, "");

    /**
     * The column <code>PUBLIC.BOOK.AUTHOR_ID</code>.
     */
    public final TableField<BookRecord, Integer> AUTHOR_ID = createField(DSL.name("AUTHOR_ID"), SQLDataType.INTEGER.nullable(false), this, "");

    /**
     * The column <code>PUBLIC.BOOK.CO_AUTHOR_ID</code>.
     */
    public final TableField<BookRecord, Integer> CO_AUTHOR_ID = createField(DSL.name("CO_AUTHOR_ID"), SQLDataType.INTEGER, this, "");

    /**
     * The column <code>PUBLIC.BOOK.DETAILS_ID</code>.
     */
    public final TableField<BookRecord, Integer> DETAILS_ID = createField(DSL.name("DETAILS_ID"), SQLDataType.INTEGER, this, "");

    /**
     * The column <code>PUBLIC.BOOK.TITLE</code>.
     */
    public final TableField<BookRecord, String> TITLE = createField(DSL.name("TITLE"), SQLDataType.VARCHAR(400).nullable(false), this, "");

    /**
     * The column <code>PUBLIC.BOOK.PUBLISHED_IN</code>.
     */
    public final TableField<BookRecord, Integer> PUBLISHED_IN = createField(DSL.name("PUBLISHED_IN"), SQLDataType.INTEGER, this, "");

    /**
     * The column <code>PUBLIC.BOOK.LANGUAGE_ID</code>.
     */
    public final TableField<BookRecord, Integer> LANGUAGE_ID = createField(DSL.name("LANGUAGE_ID"), SQLDataType.INTEGER, this, "");

    /**
     * The column <code>PUBLIC.BOOK.CONTENT_TEXT</code>.
     */
    public final TableField<BookRecord, String> CONTENT_TEXT = createField(DSL.name("CONTENT_TEXT"), SQLDataType.CLOB, this, "");

    /**
     * The column <code>PUBLIC.BOOK.CONTENT_PDF</code>.
     */
    public final TableField<BookRecord, byte[]> CONTENT_PDF = createField(DSL.name("CONTENT_PDF"), SQLDataType.BLOB, this, "");

    /**
     * The column <code>PUBLIC.BOOK.REC_VERSION</code>.
     */
    public final TableField<BookRecord, Integer> REC_VERSION = createField(DSL.name("REC_VERSION"), SQLDataType.INTEGER, this, "");

    /**
     * The column <code>PUBLIC.BOOK.REC_TIMESTAMP</code>.
     */
    public final TableField<BookRecord, LocalDateTime> REC_TIMESTAMP = createField(DSL.name("REC_TIMESTAMP"), SQLDataType.LOCALDATETIME(6), this, "");

    private Book(Name alias, Table<BookRecord> aliased) {
        this(alias, aliased, (Field<?>[]) null, null);
    }

    private Book(Name alias, Table<BookRecord> aliased, Field<?>[] parameters, Condition where) {
        super(alias, null, aliased, parameters, DSL.comment(""), TableOptions.table(), where);
    }

    /**
     * Create an aliased <code>PUBLIC.BOOK</code> table reference
     */
    public Book(String alias) {
        this(DSL.name(alias), BOOK);
    }

    /**
     * Create an aliased <code>PUBLIC.BOOK</code> table reference
     */
    public Book(Name alias) {
        this(alias, BOOK);
    }

    /**
     * Create a <code>PUBLIC.BOOK</code> table reference
     */
    public Book() {
        this(DSL.name("BOOK"), null);
    }

    public <O extends Record> Book(Table<O> path, ForeignKey<O, BookRecord> childPath, InverseForeignKey<O, BookRecord> parentPath) {
        super(path, childPath, parentPath, BOOK);
    }

    /**
     * A subtype implementing {@link Path} for simplified path-based joins.
     */
    public static class BookPath extends Book implements Path<BookRecord> {
        public <O extends Record> BookPath(Table<O> path, ForeignKey<O, BookRecord> childPath, InverseForeignKey<O, BookRecord> parentPath) {
            super(path, childPath, parentPath);
        }
        private BookPath(Name alias, Table<BookRecord> aliased) {
            super(alias, aliased);
        }

        @Override
        public BookPath as(String alias) {
            return new BookPath(DSL.name(alias), this);
        }

        @Override
        public BookPath as(Name alias) {
            return new BookPath(alias, this);
        }

        @Override
        public BookPath as(Table<?> alias) {
            return new BookPath(alias.getQualifiedName(), this);
        }
    }

    @Override
    public Schema getSchema() {
        return aliased() ? null : Public.PUBLIC;
    }

    @Override
    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.FK_T_BOOK_AUTHOR_ID, Indexes.FK_T_BOOK_CO_AUTHOR_ID, Indexes.PK_T_BOOK);
    }

    @Override
    public UniqueKey<BookRecord> getPrimaryKey() {
        return Keys.PK_T_BOOK;
    }

    @Override
    public List<ForeignKey<BookRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_T_BOOK_AUTHOR_ID, Keys.FK_T_BOOK_CO_AUTHOR_ID);
    }

    private transient AuthorPath _fkTBookAuthorId;

    /**
     * Get the implicit join path to the <code>PUBLIC.AUTHOR</code> table, via
     * the <code>FK_T_BOOK_AUTHOR_ID</code> key.
     */
    public AuthorPath fkTBookAuthorId() {
        if (_fkTBookAuthorId == null)
            _fkTBookAuthorId = new AuthorPath(this, Keys.FK_T_BOOK_AUTHOR_ID, null);

        return _fkTBookAuthorId;
    }

    private transient AuthorPath _fkTBookCoAuthorId;

    /**
     * Get the implicit join path to the <code>PUBLIC.AUTHOR</code> table, via
     * the <code>FK_T_BOOK_CO_AUTHOR_ID</code> key.
     */
    public AuthorPath fkTBookCoAuthorId() {
        if (_fkTBookCoAuthorId == null)
            _fkTBookCoAuthorId = new AuthorPath(this, Keys.FK_T_BOOK_CO_AUTHOR_ID, null);

        return _fkTBookCoAuthorId;
    }

    private transient BookToBookStorePath _bookToBookStore;

    /**
     * Get the implicit to-many join path to the
     * <code>PUBLIC.BOOK_TO_BOOK_STORE</code> table
     */
    public BookToBookStorePath bookToBookStore() {
        if (_bookToBookStore == null)
            _bookToBookStore = new BookToBookStorePath(this, null, Keys.FK_B2BS_B_ID.getInverseKey());

        return _bookToBookStore;
    }

    /**
     * Get the implicit many-to-many join path to the
     * <code>PUBLIC.BOOK_STORE</code> table
     */
    public BookStorePath bookStore() {
        return bookToBookStore().bookStore();
    }

    @Override
    public Book as(String alias) {
        return new Book(DSL.name(alias), this);
    }

    @Override
    public Book as(Name alias) {
        return new Book(alias, this);
    }

    @Override
    public Book as(Table<?> alias) {
        return new Book(alias.getQualifiedName(), this);
    }

    /**
     * Rename this table
     */
    @Override
    public Book rename(String name) {
        return new Book(DSL.name(name), null);
    }

    /**
     * Rename this table
     */
    @Override
    public Book rename(Name name) {
        return new Book(name, null);
    }

    /**
     * Rename this table
     */
    @Override
    public Book rename(Table<?> name) {
        return new Book(name.getQualifiedName(), null);
    }

    /**
     * Create an inline derived table from this table
     */
    @Override
    public Book where(Condition condition) {
        return new Book(getQualifiedName(), aliased() ? this : null, null, condition);
    }

    /**
     * Create an inline derived table from this table
     */
    @Override
    public Book where(Collection<? extends Condition> conditions) {
        return where(DSL.and(conditions));
    }

    /**
     * Create an inline derived table from this table
     */
    @Override
    public Book where(Condition... conditions) {
        return where(DSL.and(conditions));
    }

    /**
     * Create an inline derived table from this table
     */
    @Override
    public Book where(Field<Boolean> condition) {
        return where(DSL.condition(condition));
    }

    /**
     * Create an inline derived table from this table
     */
    @Override
    @PlainSQL
    public Book where(SQL condition) {
        return where(DSL.condition(condition));
    }

    /**
     * Create an inline derived table from this table
     */
    @Override
    @PlainSQL
    public Book where(@Stringly.SQL String condition) {
        return where(DSL.condition(condition));
    }

    /**
     * Create an inline derived table from this table
     */
    @Override
    @PlainSQL
    public Book where(@Stringly.SQL String condition, Object... binds) {
        return where(DSL.condition(condition, binds));
    }

    /**
     * Create an inline derived table from this table
     */
    @Override
    @PlainSQL
    public Book where(@Stringly.SQL String condition, QueryPart... parts) {
        return where(DSL.condition(condition, parts));
    }

    /**
     * Create an inline derived table from this table
     */
    @Override
    public Book whereExists(Select<?> select) {
        return where(DSL.exists(select));
    }

    /**
     * Create an inline derived table from this table
     */
    @Override
    public Book whereNotExists(Select<?> select) {
        return where(DSL.notExists(select));
    }
}
