/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.jms.JmsBrowsableEndpoint;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.spi.BrowsableEndpoint;
import org.springframework.jms.core.JmsOperations;

public class DefaultQueueBrowseStrategy
implements QueueBrowseStrategy {
    @Override
    public List<Exchange> browse(JmsOperations template, String queue, JmsBrowsableEndpoint endpoint, int limit) {
        if (endpoint.getSelector() != null) {
            return (List)template.browseSelected(queue, endpoint.getSelector(), (session, browser) -> DefaultQueueBrowseStrategy.doBrowse(endpoint, session, browser, limit));
        }
        return (List)template.browse(queue, (session, browser) -> DefaultQueueBrowseStrategy.doBrowse(endpoint, session, browser, limit));
    }

    @Override
    public BrowsableEndpoint.BrowseStatus browseStatus(JmsOperations template, String queue, JmsBrowsableEndpoint endpoint, int limit) {
        if (endpoint.getSelector() != null) {
            return (BrowsableEndpoint.BrowseStatus)template.browseSelected(queue, endpoint.getSelector(), (session, browser) -> DefaultQueueBrowseStrategy.doBrowseStatus(endpoint, session, browser, limit));
        }
        return (BrowsableEndpoint.BrowseStatus)template.browse(queue, (session, browser) -> DefaultQueueBrowseStrategy.doBrowseStatus(endpoint, session, browser, limit));
    }

    private static List<Exchange> doBrowse(JmsBrowsableEndpoint endpoint, Session session, QueueBrowser browser, int limit) throws JMSException {
        if (limit <= 0) {
            limit = Integer.MAX_VALUE;
        }
        ArrayList<Exchange> answer = new ArrayList<Exchange>();
        Enumeration iter = browser.getEnumeration();
        for (int i = 0; i < limit && iter.hasMoreElements(); ++i) {
            Message message = (Message)iter.nextElement();
            Exchange exchange = endpoint.createExchange(message, session);
            answer.add(exchange);
        }
        return answer;
    }

    private static BrowsableEndpoint.BrowseStatus doBrowseStatus(JmsBrowsableEndpoint endpoint, Session session, QueueBrowser browser, int limit) throws JMSException {
        if (limit <= 0) {
            limit = Integer.MAX_VALUE;
        }
        Enumeration iter = browser.getEnumeration();
        int size = 0;
        long ts1 = 0L;
        long ts2 = 0L;
        Message message = null;
        for (int i = 0; i < limit && iter.hasMoreElements(); ++i) {
            message = (Message)iter.nextElement();
            if (i == 0) {
                ts1 = message.getJMSTimestamp();
            }
            ++size;
        }
        if (message != null && size > 0) {
            ts2 = message.getJMSTimestamp();
        }
        return new BrowsableEndpoint.BrowseStatus(size, ts1, ts2);
    }
}

