/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import jakarta.jms.ConnectionFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.support.ObjectHelper;

final class JmsServiceLocationHelper {
    private JmsServiceLocationHelper() {
    }

    public static String getBrokerURLFromConnectionFactory(BeanIntrospection bi, ConnectionFactory cf) {
        if (cf == null) {
            return null;
        }
        HashMap props = new HashMap();
        bi.getProperties((Object)cf, props, null, false);
        Object url = props.get("brokerURL");
        if (url != null) {
            return url.toString();
        }
        ConnectionFactory ncf = (ConnectionFactory)props.get("connectionFactory");
        if (ncf != null) {
            return JmsServiceLocationHelper.getBrokerURLFromConnectionFactory(bi, ncf);
        }
        return JmsServiceLocationHelper.artemisBrokerURL(cf);
    }

    public static String getUsernameFromConnectionFactory(BeanIntrospection bi, ConnectionFactory cf) {
        if (cf == null) {
            return null;
        }
        HashMap props = new HashMap();
        bi.getProperties((Object)cf, props, null, false);
        Object user = props.get("user");
        if (user == null) {
            user = props.get("username");
        }
        if (user == null) {
            user = props.get("userName");
        }
        if (user != null) {
            return user.toString();
        }
        ConnectionFactory ncf = (ConnectionFactory)props.get("connectionFactory");
        if (ncf != null) {
            return JmsServiceLocationHelper.getUsernameFromConnectionFactory(bi, ncf);
        }
        return JmsServiceLocationHelper.artemisUsername(cf);
    }

    private static String artemisBrokerURL(ConnectionFactory cf) {
        try {
            Map map;
            Object[] arr;
            Object obj;
            if ("org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory".equals(cf.getClass().getName()) && (obj = ObjectHelper.invokeMethodSafe((String)"getServerLocator", (Object)cf, (Object[])new Object[0])) != null && (arr = (Object[])ObjectHelper.invokeMethodSafe((String)"getStaticTransportConfigurations", (Object)obj, (Object[])new Object[0])) != null && arr.length > 0 && (map = (Map)ObjectHelper.invokeMethodSafe((String)"getParams", (Object)(obj = arr[0]), (Object[])new Object[0])) != null) {
                Object host = map.get("host");
                Object port = map.get("port");
                if (host != null && port != null) {
                    return host + ":" + port;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String artemisUsername(ConnectionFactory cf) {
        try {
            if ("org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory".equals(cf.getClass().getName())) {
                return (String)ObjectHelper.invokeMethodSafe((String)"getUser", (Object)cf, (Object[])new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

