/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.producer;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Issue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class WatcherProducer
extends DefaultProducer {
    public WatcherProducer(JiraEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) {
        String issueKey = (String)exchange.getIn().getHeader("IssueKey", String.class);
        String watchersAdd = (String)exchange.getIn().getHeader("IssueWatchersAdd", String.class);
        String watchersRemove = (String)exchange.getIn().getHeader("IssueWatchersRemove", String.class);
        if (issueKey == null) {
            throw new IllegalArgumentException("Missing exchange input header named 'IssueKey', it should specify the issue key to add/remove watchers to.");
        }
        JiraRestClient client = ((JiraEndpoint)this.getEndpoint()).getClient();
        boolean hasWatchersToAdd = ObjectHelper.isNotEmpty((String)watchersAdd);
        boolean hasWatchersToRemove = ObjectHelper.isNotEmpty((String)watchersRemove);
        if (hasWatchersToAdd || hasWatchersToRemove) {
            String watcher;
            String[] watArr;
            IssueRestClient issueClient = client.getIssueClient();
            Issue issue = (Issue)issueClient.getIssue(issueKey).claim();
            if (hasWatchersToAdd) {
                for (String s : watArr = watchersAdd.split(",")) {
                    watcher = s.trim();
                    if (watcher.isEmpty()) continue;
                    issueClient.addWatcher(issue.getWatchers().getSelf(), watcher);
                }
            }
            if (hasWatchersToRemove) {
                for (String s : watArr = watchersRemove.split(",")) {
                    watcher = s.trim();
                    if (watcher.isEmpty()) continue;
                    issueClient.removeWatcher(issue.getWatchers().getSelf(), watcher);
                }
            }
        }
    }
}

