/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.producer;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.input.WorklogInput;
import java.net.URI;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.joda.time.DateTime;

public class AddWorkLogProducer
extends DefaultProducer {
    private static final int DEFAULT_MINUTES_SPENT = -1;

    public AddWorkLogProducer(JiraEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) {
        String issueKey = (String)exchange.getIn().getHeader("IssueKey", String.class);
        if (issueKey == null) {
            throw new IllegalArgumentException("Missing exchange input header named IssueKey");
        }
        String comment = (String)exchange.getIn().getBody(String.class);
        if (comment == null) {
            throw new IllegalArgumentException("Missing exchange body, it should specify the string comment.");
        }
        int minutesSpent = (Integer)exchange.getIn().getHeader("minutesSpent", (Object)-1, Integer.TYPE);
        if (-1 == minutesSpent) {
            throw new IllegalArgumentException("Missing exchange input header named minutesSpent");
        }
        JiraRestClient client = ((JiraEndpoint)this.getEndpoint()).getClient();
        IssueRestClient issueClient = client.getIssueClient();
        Issue issue = (Issue)issueClient.getIssue(issueKey).claim();
        WorklogInput worklogInput = WorklogInput.create((URI)issue.getSelf(), (String)comment, (DateTime)new DateTime(), (int)minutesSpent);
        issueClient.addWorklog(issue.getWorklogUri(), worklogInput);
    }
}

