/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;

@Converter(generateLoader=true)
public final class FileConverter {
    private FileConverter() {
    }

    @Converter
    public static File genericToFile(GenericFile<File> genericFile, Exchange exchange) throws IOException {
        Object body = genericFile.getBody();
        File file = null;
        if (body instanceof byte[]) {
            byte[] bos = (byte[])body;
            Path path = Files.createTempFile(genericFile.getFileName(), null, new FileAttribute[0]);
            Files.write(path, bos, StandardOpenOption.CREATE);
            path.toFile().deleteOnExit();
        } else {
            file = (File)body;
        }
        return file;
    }
}

