/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.consumer;

import com.atlassian.jira.rest.client.domain.BasicIssue;
import java.util.List;
import java.util.Stack;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jira.JIRAEndpoint;
import org.apache.camel.component.jira.consumer.AbstractJIRAConsumer;

public class NewIssueConsumer
extends AbstractJIRAConsumer {
    private final String jql;
    private long latestIssueId = -1L;

    public NewIssueConsumer(JIRAEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.jql = endpoint.getJql() + " ORDER BY key desc";
        List<BasicIssue> issues = this.getIssues(this.jql, 0, 1, 1);
        if (issues.size() >= 1) {
            this.latestIssueId = issues.get(0).getId();
        }
    }

    @Override
    protected int poll() throws Exception {
        Stack<BasicIssue> newIssues = new Stack<BasicIssue>();
        this.getNewIssues(0, newIssues);
        while (!newIssues.empty()) {
            BasicIssue newIssue = newIssues.pop();
            Exchange e = this.getEndpoint().createExchange();
            e.getIn().setBody((Object)newIssue);
            this.getProcessor().process(e);
        }
        return newIssues.size();
    }

    private void getNewIssues(int start, Stack<BasicIssue> stack) {
        long id;
        List<BasicIssue> issues = this.getIssues(this.jql, start, 1, 1);
        if (issues.size() >= 1 && (id = issues.get(0).getId().longValue()) > this.latestIssueId) {
            stack.push(issues.get(0));
            this.getNewIssues(start + 1, stack);
            this.latestIssueId = id;
        }
    }
}

