/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.jibx;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class JibxDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    public static final String UNMARSHALL_CLASS = "CamelJibxUnmarshallClass";
    private Class<?> unmarshallClass;
    private String bindingName;
    private boolean contentTypeHeader = true;

    public JibxDataFormat() {
    }

    public JibxDataFormat(Class<?> unmarshallClass) {
        this.setUnmarshallClass(unmarshallClass);
    }

    public JibxDataFormat(Class<?> unmarshallClass, String bindingName) {
        this.setUnmarshallClass(unmarshallClass);
        this.setBindingName(bindingName);
    }

    public String getDataFormatName() {
        return "jibx";
    }

    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        IBindingFactory bindingFactory = this.createBindingFactory(body.getClass(), this.bindingName);
        IMarshallingContext marshallingContext = bindingFactory.createMarshallingContext();
        marshallingContext.marshalDocument(body, null, null, stream);
        if (this.contentTypeHeader) {
            if (exchange.hasOut()) {
                exchange.getOut().setHeader("Content-Type", (Object)"application/xml");
            } else {
                exchange.getIn().setHeader("Content-Type", (Object)"application/xml");
            }
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        Class<?> unmarshallType = (Class<?>)exchange.getIn().getHeader(UNMARSHALL_CLASS, Class.class);
        if (unmarshallType == null) {
            unmarshallType = this.getUnmarshallClass();
        }
        ObjectHelper.notNull(unmarshallType, (String)"unmarshallClass or CamelJibxUnmarshallClass header");
        IBindingFactory bindingFactory = this.createBindingFactory(unmarshallType, this.bindingName);
        IUnmarshallingContext unmarshallingContext = bindingFactory.createUnmarshallingContext();
        return unmarshallingContext.unmarshalDocument(stream, null);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public Class<?> getUnmarshallClass() {
        return this.unmarshallClass;
    }

    public void setUnmarshallClass(Class<?> unmarshallClass) {
        this.unmarshallClass = unmarshallClass;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public boolean isContentTypeHeader() {
        return this.contentTypeHeader;
    }

    public void setContentTypeHeader(boolean contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    private IBindingFactory createBindingFactory(Class<?> clazz, String bindingName) throws JiBXException {
        if (bindingName == null) {
            return BindingDirectory.getFactory(clazz);
        }
        return BindingDirectory.getFactory((String)bindingName, clazz);
    }
}

