/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.startup.jfr;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import jdk.jfr.Configuration;
import jdk.jfr.FlightRecorder;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;
import org.apache.camel.StartupStep;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.startup.jfr.FlightRecorderStartupStep;
import org.apache.camel.support.startup.DefaultStartupStepRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="startup-step-recorder")
public class FlightRecorderStartupStepRecorder
extends DefaultStartupStepRecorder {
    private static final Logger LOG = LoggerFactory.getLogger(FlightRecorderStartupStepRecorder.class);
    private Recording rec;
    private FlightRecorderListener frl;

    public void doStart() throws Exception {
        super.doStart();
        if (this.isRecording()) {
            FlightRecorder.register(FlightRecorderStartupStep.class);
            Configuration config = Configuration.getConfiguration(this.getRecordingProfile());
            this.rec = new Recording(config);
            this.rec.setName("Camel Recording");
            if (!"false".equals(this.getRecordingDir())) {
                Path dir = this.getRecordingDir() != null ? Paths.get(this.getRecordingDir(), new String[0]) : Paths.get(".", new String[0]);
                Path file = Files.createTempFile(dir, "camel-recording", ".jfr", new FileAttribute[0]);
                this.rec.setDestination(file);
            }
            if (this.getStartupRecorderDuration() == 0L) {
                if (this.rec.getDestination() != null) {
                    this.rec.setDumpOnExit(true);
                    LOG.info("Java flight recorder will be saved to file on JVM exit: {}", (Object)this.rec.getDestination());
                }
            } else if (this.getStartupRecorderDuration() > 0L) {
                this.rec.setDuration(Duration.ofSeconds(this.getStartupRecorderDuration()));
                LOG.info("Starting Java flight recorder with profile: {} and duration: {} seconds", (Object)this.getRecordingProfile(), (Object)this.getStartupRecorderDuration());
                this.frl = new FlightRecorderListener(){

                    @Override
                    public void recordingStateChanged(Recording recording) {
                        if (recording == FlightRecorderStartupStepRecorder.this.rec && recording.getState().equals((Object)RecordingState.STOPPED)) {
                            LOG.info("Java flight recorder stopped after {} seconds and saved to file: {}", (Object)FlightRecorderStartupStepRecorder.this.getStartupRecorderDuration(), (Object)FlightRecorderStartupStepRecorder.this.rec.getDestination());
                        }
                    }
                };
                FlightRecorder.addListener(this.frl);
            } else {
                LOG.info("Starting Java flight recorder with profile: {}", (Object)this.getRecordingProfile());
            }
            this.rec.start();
        }
    }

    public void doStop() throws Exception {
        super.doStop();
        if (this.rec != null) {
            if (this.getStartupRecorderDuration() < 0L) {
                LOG.debug("Stopping Java flight recorder");
                System.gc();
                this.rec.stop();
                LOG.info("Java flight recorder stopped and saved to file: {}", (Object)this.rec.getDestination());
            }
            FlightRecorder.unregister(FlightRecorderStartupStep.class);
            if (this.frl != null) {
                FlightRecorder.removeListener(this.frl);
            }
            this.rec = null;
            this.frl = null;
        }
    }

    public StartupStep createStartupStep(String type, String name, String description, int id, int parentId, int level) {
        return new FlightRecorderStartupStep(name, id, parentId, level, type, description);
    }

    public String toString() {
        return "java-flight-recorder";
    }
}

