/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jdbc.BeanRowMapper;
import org.apache.camel.component.jdbc.JdbcHelper;

public final class StreamListIterator
implements Iterator {
    private final CamelContext camelContext;
    private final String outputClass;
    private final BeanRowMapper beanRowMapper;
    private final Iterator delegate;

    public StreamListIterator(CamelContext camelContext, String outputClass, BeanRowMapper beanRowMapper, Iterator delegate) {
        this.camelContext = camelContext;
        this.outputClass = outputClass;
        this.beanRowMapper = beanRowMapper;
        this.delegate = delegate;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public Object next() {
        Object answer;
        Map row = (Map)this.delegate.next();
        if (row != null && this.outputClass != null) {
            try {
                answer = JdbcHelper.newBeanInstance(this.camelContext, this.outputClass, this.beanRowMapper, row);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        } else {
            answer = row;
        }
        return answer;
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    public void forEachRemaining(Consumer action) {
        this.delegate.forEachRemaining(action);
    }
}

