/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.SuspendableService;
import org.apache.camel.component.jcr.EndpointEventListener;
import org.apache.camel.component.jcr.JcrEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrConsumer
extends DefaultConsumer
implements SuspendableService {
    private static final transient Logger LOG = LoggerFactory.getLogger(JcrConsumer.class);
    private Session session;
    private EventListener eventListener;
    private ScheduledFuture<?> sessionListenerCheckerScheduledFuture;

    public JcrConsumer(JcrEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.scheduleSessionListenerChecker();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.cancelSessionListenerChecker();
        this.unregisterListenerAndLogoutSession();
    }

    protected void doSuspend() throws Exception {
        super.doSuspend();
        this.cancelSessionListenerChecker();
        this.unregisterListenerAndLogoutSession();
    }

    protected void doResume() throws Exception {
        super.doResume();
        this.scheduleSessionListenerChecker();
    }

    protected JcrEndpoint getJcrEndpoint() {
        JcrEndpoint endpoint = (JcrEndpoint)this.getEndpoint();
        return endpoint;
    }

    private synchronized void createSessionAndRegisterListener() throws RepositoryException {
        LOG.trace("createSessionAndRegisterListener START");
        this.session = this.getJcrEndpoint().getRepository().login(this.getJcrEndpoint().getCredentials());
        int eventTypes = this.getJcrEndpoint().getEventTypes();
        String absPath = this.getJcrEndpoint().getBase();
        if (absPath == null) {
            absPath = "/";
        } else if (!absPath.startsWith("/")) {
            absPath = "/" + absPath;
        }
        boolean isDeep = this.getJcrEndpoint().isDeep();
        String[] uuid = null;
        String uuids = this.getJcrEndpoint().getUuids();
        if (uuids != null && !"".equals(uuids = uuids.trim())) {
            uuid = uuids.split(",");
        }
        String[] nodeTypeName = null;
        String nodeTypeNames = this.getJcrEndpoint().getNodeTypeNames();
        if (nodeTypeNames != null && !"".equals(nodeTypeNames = nodeTypeNames.trim())) {
            nodeTypeName = nodeTypeNames.split(",");
        }
        boolean noLocal = this.getJcrEndpoint().isNoLocal();
        this.eventListener = new EndpointEventListener(this.getJcrEndpoint(), this.getProcessor());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding JCR Event Listener, {}, on {}. eventTypes=" + eventTypes + ", isDeep=" + isDeep + ", uuid=" + uuid + ", nodeTypeName=" + nodeTypeName + ", noLocal=" + noLocal, (Object)this.eventListener, (Object)absPath);
        }
        this.session.getWorkspace().getObservationManager().addEventListener(this.eventListener, eventTypes, absPath, isDeep, uuid, nodeTypeName, noLocal);
        LOG.trace("createSessionAndRegisterListener END");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void unregisterListenerAndLogoutSession() throws RepositoryException {
        LOG.trace("unregisterListenerAndLogoutSession START");
        if (this.session != null) {
            try {
                if (!this.session.isLive()) {
                    LOG.info("Session was is no more live.");
                } else {
                    if (this.eventListener != null) {
                        this.session.getWorkspace().getObservationManager().removeEventListener(this.eventListener);
                        this.eventListener = null;
                    }
                    this.session.logout();
                }
            }
            finally {
                this.eventListener = null;
                this.session = null;
            }
        }
        LOG.trace("unregisterListenerAndLogoutSession END");
    }

    private void cancelSessionListenerChecker() {
        if (this.sessionListenerCheckerScheduledFuture != null) {
            this.sessionListenerCheckerScheduledFuture.cancel(true);
        }
    }

    private void scheduleSessionListenerChecker() {
        String name = "JcrConsumerSessionChecker[" + this.getJcrEndpoint().getEndpointConfiguredDestinationName() + "]";
        ScheduledExecutorService executor = this.getJcrEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, name);
        JcrConsumerSessionListenerChecker sessionListenerChecker = new JcrConsumerSessionListenerChecker();
        long sessionLiveCheckIntervalOnStart = this.getJcrEndpoint().getSessionLiveCheckIntervalOnStart();
        long sessionLiveCheckInterval = this.getJcrEndpoint().getSessionLiveCheckInterval();
        this.sessionListenerCheckerScheduledFuture = executor.scheduleWithFixedDelay(sessionListenerChecker, sessionLiveCheckIntervalOnStart, sessionLiveCheckInterval, TimeUnit.MILLISECONDS);
    }

    private class JcrConsumerSessionListenerChecker
    implements Runnable {
        private JcrConsumerSessionListenerChecker() {
        }

        @Override
        public void run() {
            LOG.debug("JcrConsumerSessionListenerChecker starts.");
            boolean isSessionLive = false;
            if (JcrConsumer.this.session != null) {
                try {
                    isSessionLive = JcrConsumer.this.session.isLive();
                }
                catch (Exception e) {
                    LOG.debug("Exception while checking jcr session", (Throwable)e);
                }
            }
            if (!isSessionLive) {
                try {
                    JcrConsumer.this.createSessionAndRegisterListener();
                }
                catch (RepositoryException e) {
                    LOG.error("Failed to create session and register listener", (Throwable)e);
                }
            }
            LOG.debug("JcrConsumerSessionListenerChecker stops.");
        }
    }
}

