/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache.osgi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import javax.cache.Cache;
import org.apache.camel.component.jcache.JCacheConfiguration;
import org.apache.camel.component.jcache.JCacheHelper;
import org.apache.camel.component.jcache.JCacheManager;
import org.apache.camel.component.jcache.JCacheProvider;
import org.apache.camel.component.jcache.JCacheProviders;
import org.apache.camel.util.ObjectHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public final class OSGiCacheManager<K, V>
extends JCacheManager {
    public OSGiCacheManager(JCacheConfiguration configuration) {
        super(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Cache<K, V> doGetCache(JCacheProvider provider) throws Exception {
        ClassLoader jcl = this.getClassLoader(provider.className());
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (jcl != null) {
                Thread.currentThread().setContextClassLoader(jcl);
            }
            Cache cache = super.doGetCache(provider);
            if (provider == JCacheProviders.hazelcast && jcl != null) {
                cache = JCacheHelper.tcclProxy(cache, Cache.class, jcl);
            }
            Cache cache2 = cache;
            return cache2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private ClassLoader getClassLoader(String providerName) throws Exception {
        if (providerName == null || !this.getConfiguration().isLookupProviders()) {
            return null;
        }
        BundleContext bc = FrameworkUtil.getBundle(JCacheHelper.class).getBundleContext();
        ClassLoader bcl = ((BundleWiring)bc.getBundle().adapt(BundleWiring.class)).getClassLoader();
        final ClassLoader acl = this.getConfiguration().getApplicationContextClassLoader();
        for (final Bundle bundle : bc.getBundles()) {
            URL spi = bundle.getResource("META-INF/services/javax.cache.spi.CachingProvider");
            if (spi == null) continue;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(spi.openStream()));){
                if (!ObjectHelper.equal((Object)providerName, (Object)in.readLine())) continue;
                ClassLoader classLoader = new ClassLoader(bcl){

                    @Override
                    protected Class<?> findClass(String name) throws ClassNotFoundException {
                        try {
                            return acl.loadClass(name);
                        }
                        catch (ClassNotFoundException e) {
                            return bundle.loadClass(name);
                        }
                    }

                    @Override
                    protected URL findResource(String name) {
                        URL resource = acl.getResource(name);
                        if (resource == null) {
                            resource = bundle.getResource(name);
                        }
                        return resource;
                    }

                    protected Enumeration findResources(String name) throws IOException {
                        try {
                            return acl.getResources(name);
                        }
                        catch (IOException e) {
                            return bundle.getResources(name);
                        }
                    }
                };
                return classLoader;
            }
        }
        return null;
    }
}

