/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class JBPMEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":connectionURL";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "jbpm".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "connectionURL", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "eventListenerType", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(33);
        props.add("attachmentId");
        props.add("bridgeErrorHandler");
        props.add("connectionURL");
        props.add("contentId");
        props.add("deploymentId");
        props.add("emitterSendItems");
        props.add("entities");
        props.add("event");
        props.add("eventListenerType");
        props.add("eventType");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("extraJaxbClasses");
        props.add("identifier");
        props.add("lazyStartProducer");
        props.add("maxNumber");
        props.add("operation");
        props.add("page");
        props.add("pageSize");
        props.add("parameters");
        props.add("password");
        props.add("processId");
        props.add("processInstanceId");
        props.add("statuses");
        props.add("synchronous");
        props.add("targetUserId");
        props.add("task");
        props.add("taskId");
        props.add("timeout");
        props.add("userId");
        props.add("userName");
        props.add("value");
        props.add("workItemId");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("userName");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

