/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm;

import org.apache.camel.spi.Metadata;

public interface JBPMConstants {
    @Metadata(label="producer", description="The value to assign to the global identifier", javaType="Object")
    public static final String VALUE = "CamelJBPMValue";
    @Metadata(label="producer", description="The operation to perform. The operation name must be prefixed with\nCamelJBPMOperation and the name of the operation. See the full list\nabove. It is case-insensitive.", javaType="String", defaultValue="PUT")
    public static final String OPERATION = "CamelJBPMOperation";
    @Metadata(label="producer", description="The id of the process that should be acted upon", javaType="String")
    public static final String PROCESS_ID = "CamelJBPMProcessId";
    @Metadata(label="producer", description="The id of the process instance", javaType="Long")
    public static final String PROCESS_INSTANCE_ID = "CamelJBPMProcessInstanceId";
    @Metadata(label="producer", description="The variables that should be set for various operations", javaType="Map<String, Object>")
    public static final String PARAMETERS = "CamelJBPMParameters";
    @Metadata(label="producer", description="The type of event to use when signalEvent operation is performed", javaType="String")
    public static final String EVENT_TYPE = "CamelJBPMEventType";
    @Metadata(label="producer", description="The type of the received event. Possible values defined here\norg.infinispan.notifications.cachelistener.event.Event.Type", javaType="Object")
    public static final String EVENT = "CamelJBPMEvent";
    @Metadata(label="producer", description="The maximum number of rules that should be fired", javaType="Integer")
    public static final String MAX_NUMBER = "CamelJBPMMaxNumber";
    @Metadata(label="producer", description="The global identifier", javaType="String")
    public static final String IDENTIFIER = "CamelJBPMIdentifier";
    @Metadata(label="producer", description="The id of the work item", javaType="Long")
    public static final String WORK_ITEM_ID = "CamelJBPMWorkItemId";
    @Metadata(label="producer", description="The id of the task", javaType="Long")
    public static final String TASK_ID = "CamelJBPMTaskId";
    @Metadata(label="producer", description="The task instance to use with task operations", javaType="org.kie.api.task.model.Task")
    public static final String TASK = "CamelJBPMTask";
    @Metadata(label="producer", description="The userId to use with task operations", javaType="String")
    public static final String USER_ID = "CamelJBPMUserId";
    @Metadata(label="producer", description="The targetUserId used when delegating a task", javaType="String")
    public static final String TARGET_USER_ID = "CamelJBPMTargetUserId";
    @Metadata(label="producer", description="The attachId to use when retrieving attachments", javaType="Long")
    public static final String ATTACHMENT_ID = "CamelJBPMAttachmentId";
    @Metadata(label="producer", description="The contentId to use when retrieving attachments", javaType="Long")
    public static final String CONTENT_ID = "CamelJBPMContentId";
    @Metadata(label="producer", description="The potentialOwners when nominateTask operation is performed", javaType="List<String>")
    public static final String ENTITY_LIST = "CamelJBPMEntityList";
    @Metadata(label="producer", description="The list of status to use when filtering tasks.", javaType="List<String>")
    public static final String STATUS_LIST = "CamelJBPMStatusList";
    @Metadata(label="producer", description="The page to use when retrieving user tasks", javaType="Integer")
    public static final String RESULT_PAGE = "CamelJBPMResultPage";
    @Metadata(label="producer", description="The page size to use when retrieving user tasks", javaType="Integer")
    public static final String RESULT_PAGE_SIZE = "CamelJBPMResultPageSize";
    public static final String JBPM_PROCESS_EVENT_LISTENER = "process";
    public static final String JBPM_TASK_EVENT_LISTENER = "task";
    public static final String JBPM_CASE_EVENT_LISTENER = "case";
    public static final String JBPM_EVENT_EMITTER = "emitter";
    public static final String GLOBAL_CAMEL_CONTEXT_SERVICE_KEY = "GlobalCamelService";
    public static final String DEPLOYMENT_CAMEL_CONTEXT_SERVICE_KEY_POSTFIX = "_CamelService";
    public static final String CAMEL_ENDPOINT_ID_WI_PARAM = "CamelEndpointId";
    public static final String HANDLE_EXCEPTION_WI_PARAM = "HandleExceptions";
    public static final String RESPONSE_WI_PARAM = "Response";
    public static final String MESSAGE_WI_PARAM = "Message";
    public static final String CAMEL_CONTEXT_BUILDER_KEY = "CamelContextBuilder";
}

