/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.BaseTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.v1.integrationspec.Traits;
import org.apache.camel.v1.integrationspec.traits.Environment;

public class EnvTrait
extends BaseTrait {
    public EnvTrait() {
        super("env", 1605);
    }

    @Override
    public boolean configure(Traits traitConfig, TraitContext context) {
        Optional<DeploymentBuilder> deployment = context.getDeployment();
        if (deployment.isEmpty()) {
            return false;
        }
        return traitConfig.getEnvironment() != null && Optional.ofNullable(traitConfig.getEnvironment().getEnabled()).orElse(true) != false;
    }

    @Override
    public void apply(Traits traitConfig, TraitContext context) {
        Environment envTrait = traitConfig.getEnvironment();
        if (ObjectHelper.isNotEmpty((Collection)envTrait.getVars())) {
            context.doWithDeployments((Visitor<DeploymentBuilder>)((Visitor)d -> ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)d.editSpec().editTemplate().editSpec().editFirstContainer().addAllToEnv((Collection)envTrait.getVars().stream().map(envvar -> {
                String[] parts = envvar.split("=", 2);
                return ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(parts[0])).withValue(parts[1])).build();
            }).collect(Collectors.toList()))).endContainer()).endSpec()).endTemplate()).endSpec()));
        }
    }
}

