/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.support;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;

public enum Capability {
    PlatformHttp("platform-http"),
    CircuitBreaker("circuit-breaker"),
    Health("health"),
    Tracing("tracing");

    private final String name;

    private Capability(String name) {
        this.name = name;
    }

    @JsonValue
    public String getValue() {
        return this.name;
    }

    @JsonCreator
    public static Capability fromValue(String value) {
        for (Capability c : Capability.values()) {
            if (!Objects.equals(c.name, value)) continue;
            return c;
        }
        throw new IllegalArgumentException("Unsupported value: " + value);
    }
}

