/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesHelper;
import org.apache.camel.dsl.jbang.core.common.SourceScheme;
import org.apache.camel.util.FileUtil;
import picocli.CommandLine;

@CommandLine.Command(name="logs", description={"Print the logs of a Kubernetes pod"}, sortOptions=false)
public class PodLogs
extends KubernetesBaseCommand {
    @CommandLine.Parameters(description={"The Camel file to get logs from. Integration name is derived from the file name."}, arity="0..1", paramLabel="<file>")
    protected String filePath;
    @CommandLine.Option(names={"--name"}, description={"The integration name. Use this when the name should not get derived from the source file name."})
    protected String name;
    @CommandLine.Option(names={"--label"}, description={"Label name and value used as a pod selector."})
    protected String label;
    @CommandLine.Option(names={"--container"}, description={"Name identifying the pod container to grab the logs from."})
    protected String container;
    @CommandLine.Option(names={"--tail"}, defaultValue="-1", description={"The number of lines from the end of the logs to show. Defaults to -1 to show all the lines."})
    int tail = -1;
    int maxWaitAttempts = 20;

    public PodLogs(CamelJBangMain main) {
        super(main);
    }

    public Integer doCall() throws Exception {
        String[] parts;
        if (this.name == null && this.label == null && this.filePath == null) {
            this.printer().println("Name or label selector must be set");
            return 1;
        }
        if (this.label == null) {
            String projectName = this.name != null ? KubernetesHelper.sanitize(this.name) : KubernetesHelper.sanitize(FileUtil.onlyName((String)SourceScheme.onlyName((String)this.filePath)));
            this.label = "%s=%s".formatted("camel.apache.org/integration", projectName);
        }
        if ((parts = this.label.split("=", 2)).length != 2) {
            this.printer().println("--label selector must be in syntax: key=value");
        }
        boolean shouldResume = true;
        int resumeCount = 0;
        while (shouldResume) {
            shouldResume = this.watchLogs(parts[0], parts[1], this.container, resumeCount);
            ++resumeCount;
        }
        return 0;
    }

    public boolean watchLogs(String label, String labelValue, String container, int resumeCount) {
        PodList pods = (PodList)((FilterWatchListDeletable)this.pods().withLabel(label, labelValue)).list();
        Pod pod = pods.getItems().stream().filter(p -> p.getStatus().getPhase() != null && !"Terminated".equals(p.getStatus().getPhase())).findFirst().orElse(null);
        if (pod == null) {
            if (resumeCount == 0) {
                this.printer().printf("Pod for label %s=%s not available - Waiting ...%n".formatted(label, labelValue), new Object[0]);
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.printer().printf("Interrupted while waiting for pod - %s%n", new Object[]{e.getMessage()});
            }
            return resumeCount < this.maxWaitAttempts;
        }
        String containerName = null;
        if (pod.getSpec() != null && pod.getSpec().getContainers() != null) {
            if (container != null && pod.getSpec().getContainers().stream().anyMatch(c -> container.equals(c.getName()))) {
                containerName = container;
            } else if (!pod.getSpec().getContainers().isEmpty()) {
                containerName = ((Container)pod.getSpec().getContainers().get(0)).getName();
            }
        }
        PodResource podRes = (PodResource)this.pods().withName(pod.getMetadata().getName());
        LogWatch logs = this.tail < 0 ? (containerName != null ? ((ContainerResource)podRes.inContainer((Object)containerName)).watchLog() : podRes.watchLog()) : (containerName != null ? ((ContainerResource)podRes.inContainer((Object)containerName)).tailingLines(this.tail).watchLog() : podRes.tailingLines(this.tail).watchLog());
        try (LogWatch logWatch = logs;
             BufferedReader reader = new BufferedReader(new InputStreamReader(logs.getOutput()));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.printer().println(line);
            }
        }
        catch (IOException e) {
            this.printer().println("Failed to read pod logs - " + e.getMessage());
        }
        return resumeCount < 25;
    }
}

