/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.ClusterType;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesDelete;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesExport;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.PodLogs;
import org.apache.camel.dsl.jbang.core.common.Printer;
import org.apache.camel.dsl.jbang.core.common.RuntimeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.RuntimeTypeConverter;
import org.apache.camel.dsl.jbang.core.common.SourceScheme;
import org.apache.camel.dsl.jbang.core.common.StringPrinter;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.FileWatcherResourceReloadStrategy;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.concurrent.ThreadHelper;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Run Camel application on Kubernetes"}, sortOptions=false)
public class KubernetesRun
extends KubernetesBaseCommand {
    @CommandLine.Parameters(description={"The Camel file(s) to run."}, arity="0..9", paramLabel="<files>")
    String[] filePaths;
    @CommandLine.Option(names={"--trait-profile"}, description={"The trait profile to use for the deployment."})
    String traitProfile;
    @CommandLine.Option(names={"--service-account"}, description={"The service account used to run the application."})
    String serviceAccount;
    @CommandLine.Option(names={"--property"}, description={"Add a runtime property or properties file from a path, a config map or a secret (syntax: [my-key=my-value|file:/path/to/my-conf.properties|[configmap|secret]:name])."})
    String[] properties;
    @CommandLine.Option(names={"--config"}, description={"Add a runtime configuration from a ConfigMap or a Secret (syntax: [configmap|secret]:name[/key], where name represents the configmap/secret name and key optionally represents the configmap/secret key to be filtered)."})
    String[] configs;
    @CommandLine.Option(names={"--resource"}, description={"Add a runtime resource from a Configmap or a Secret (syntax: [configmap|secret]:name[/key][@path], where name represents the configmap/secret name, key optionally represents the configmap/secret key to be filtered and path represents the destination path)."})
    String[] resources;
    @CommandLine.Option(names={"--open-api"}, description={"Add an OpenAPI spec (syntax: [configmap|file]:name)."})
    String openApi;
    @CommandLine.Option(names={"--env"}, description={"Set an environment variable in the integration container, for instance \"-e MY_VAR=my-value\"."})
    String[] envVars;
    @CommandLine.Option(names={"--volume"}, description={"Mount a volume into the integration container, for instance \"-v pvcname:/container/path\"."})
    String[] volumes;
    @CommandLine.Option(names={"--connect"}, description={"A Service that the integration should bind to, specified as [[apigroup/]version:]kind:[namespace/]name."})
    String[] connects;
    @CommandLine.Option(names={"--annotation"}, description={"Add an annotation to the integration. Use name values pairs like \"--annotation my.company=hello\"."})
    String[] annotations;
    @CommandLine.Option(names={"--label"}, description={"Add a label to the integration. Use name values pairs like \"--label my.company=hello\"."})
    String[] labels;
    @CommandLine.Option(names={"--trait"}, description={"Add a trait configuration to the integration. Use name values pairs like \"--trait trait.name.config=hello\"."})
    String[] traits;
    @CommandLine.Option(names={"--wait"}, description={"Wait for the deployment to become ready."})
    boolean wait;
    @CommandLine.Option(names={"--logs"}, description={"Print logs after Camel application has been started."})
    boolean logs;
    @CommandLine.Option(names={"--reload", "--dev"}, description={"Enables dev mode (live reload when source files are updated and saved)"})
    boolean dev;
    @CommandLine.Option(names={"--cleanup"}, defaultValue="true", description={"Automatically removes deployment when process is stopped. Only in combination with --dev, --reload option."})
    boolean cleanup = true;
    @CommandLine.Option(names={"--output"}, description={"Just output the generated integration custom resource (supports: yaml or json)."})
    String output;
    @CommandLine.Option(names={"--image"}, description={"The image name to be built."})
    String image;
    @CommandLine.Option(names={"--image-registry"}, description={"The image registry to hold the app container image."})
    String imageRegistry;
    @CommandLine.Option(names={"--image-group"}, description={"The image registry group used to push images to."})
    String imageGroup;
    @CommandLine.Option(names={"--image-builder"}, description={"The image builder used to build the container image (e.g. docker, jib, podman, s2i)."})
    String imageBuilder;
    @CommandLine.Option(names={"--cluster-type"}, description={"The target cluster type. Special configurations may be applied to different cluster types such as Kind or Minikube."})
    String clusterType;
    @CommandLine.Option(names={"--image-build"}, defaultValue="true", description={"Weather to build container image as part of the run."})
    boolean imageBuild = true;
    @CommandLine.Option(names={"--image-push"}, defaultValue="true", description={"Weather to push image to given image registry as part of the run."})
    boolean imagePush = true;
    @CommandLine.Option(names={"--image-platforms"}, description={"List of target platforms. Each platform is defined using the pattern."})
    String imagePlatforms;
    @CommandLine.Option(names={"--repository"}, description={"Additional maven repositories"})
    List<String> repositories = new ArrayList<String>();
    @CommandLine.Option(names={"--dep", "--dependency"}, description={"Add additional dependencies"}, split=",")
    List<String> dependencies = new ArrayList<String>();
    @CommandLine.Option(names={"--runtime"}, completionCandidates=RuntimeCompletionCandidates.class, defaultValue="quarkus", converter={RuntimeTypeConverter.class}, description={"Runtime (${COMPLETION-CANDIDATES})"})
    RuntimeType runtime = RuntimeType.quarkus;
    @CommandLine.Option(names={"--gav"}, description={"The Maven group:artifact:version"})
    String gav;
    @CommandLine.Option(names={"--exclude"}, description={"Exclude files by name or pattern"})
    List<String> excludes = new ArrayList<String>();
    @CommandLine.Option(names={"--maven-settings"}, description={"Optional location of Maven settings.xml file to configure servers, repositories, mirrors and proxies. If set to \"false\", not even the default ~/.m2/settings.xml will be used."})
    String mavenSettings;
    @CommandLine.Option(names={"--maven-settings-security"}, description={"Optional location of Maven settings-security.xml file to decrypt settings.xml"})
    String mavenSettingsSecurity;
    @CommandLine.Option(names={"--maven-central-enabled"}, description={"Whether downloading JARs from Maven Central repository is enabled"})
    boolean mavenCentralEnabled = true;
    @CommandLine.Option(names={"--maven-apache-snapshot-enabled"}, description={"Whether downloading JARs from ASF Maven Snapshot repository is enabled"})
    boolean mavenApacheSnapshotEnabled = true;
    @CommandLine.Option(names={"--java-version"}, description={"Java version"}, defaultValue="17")
    String javaVersion = "17";
    @CommandLine.Option(names={"--camel-version"}, description={"To export using a different Camel version than the default version."})
    String camelVersion;
    @CommandLine.Option(names={"--kamelets-version"}, description={"Apache Camel Kamelets version"})
    String kameletsVersion;
    @CommandLine.Option(names={"--profile"}, scope=CommandLine.ScopeType.INHERIT, description={"Profile to export (dev, test, or prod)."})
    String profile;
    @CommandLine.Option(names={"--local-kamelet-dir"}, description={"Local directory for loading Kamelets (takes precedence)"})
    String localKameletDir;
    @CommandLine.Option(names={"--spring-boot-version"}, description={"Spring Boot version"}, defaultValue="3.3.3")
    String springBootVersion = "3.3.3";
    @CommandLine.Option(names={"--camel-spring-boot-version"}, description={"Camel version to use with Spring Boot"})
    String camelSpringBootVersion;
    @CommandLine.Option(names={"--quarkus-group-id"}, description={"Quarkus Platform Maven groupId"}, defaultValue="io.quarkus.platform")
    String quarkusGroupId = "io.quarkus.platform";
    @CommandLine.Option(names={"--quarkus-artifact-id"}, description={"Quarkus Platform Maven artifactId"}, defaultValue="quarkus-bom")
    String quarkusArtifactId = "quarkus-bom";
    @CommandLine.Option(names={"--quarkus-version"}, description={"Quarkus Platform version"}, defaultValue="3.14.2")
    String quarkusVersion = "3.14.2";
    @CommandLine.Option(names={"--package-name"}, description={"For Java source files should they have the given package name. By default the package name is computed from the Maven GAV. Use false to turn off and not include package name in the Java source files."})
    String packageName;
    @CommandLine.Option(names={"--build-property"}, description={"Maven/Gradle build properties, ex. --build-property=prop1=foo"})
    List<String> buildProperties = new ArrayList<String>();

    public KubernetesRun(CamelJBangMain main) {
        super(main);
    }

    public Integer doCall() throws Exception {
        String projectName = this.getProjectName();
        String workingDir = ".camel-jbang-run/" + projectName;
        this.printer().println("Exporting application ...");
        Printer runPrinter = this.printer();
        StringPrinter exportPrinter = new StringPrinter();
        this.getMain().withPrinter((Printer)exportPrinter);
        KubernetesExport export = this.configureExport(workingDir);
        int exit = export.export();
        this.getMain().withPrinter(runPrinter);
        if (exit != 0) {
            this.printer().println(exportPrinter.getOutput());
            return exit;
        }
        if (this.output != null) {
            File manifest;
            if (RuntimeType.quarkus == this.runtime) {
                exit = this.buildQuarkus(workingDir);
            } else if (RuntimeType.springBoot == this.runtime) {
                exit = this.buildSpringBoot(workingDir);
            }
            if (exit != 0) {
                this.printer().println("Project build failed!");
                return exit;
            }
            switch (this.output) {
                case "yaml": {
                    manifest = KubernetesHelper.resolveKubernetesManifest(workingDir + "/target/kubernetes");
                    break;
                }
                case "json": {
                    manifest = KubernetesHelper.resolveKubernetesManifest(workingDir + "/target/kubernetes", "json");
                    break;
                }
                default: {
                    this.printer().printf("Unsupported output format '%s' (supported: yaml, json)%n", new Object[]{this.output});
                    return 1;
                }
            }
            try (FileInputStream fis = new FileInputStream(manifest);){
                this.printer().println(IOHelper.loadText((InputStream)fis));
            }
            return 0;
        }
        if (RuntimeType.quarkus == this.runtime) {
            exit = this.deployQuarkus(workingDir);
        } else if (RuntimeType.springBoot == this.runtime) {
            exit = this.deploySpringBoot(workingDir);
        }
        if (exit != 0) {
            this.printer().println("Deployment to %s failed!".formatted(Optional.ofNullable(this.clusterType).map(StringHelper::capitalize).orElse("Kubernetes")));
            return exit;
        }
        if (this.dev) {
            DefaultCamelContext reloadContext = new DefaultCamelContext(false);
            this.configureFileWatch(reloadContext, workingDir);
            reloadContext.start();
            if (this.cleanup) {
                this.installShutdownInterceptor(projectName, workingDir);
            }
        }
        if (this.dev || this.wait || this.logs) {
            ((FilterWatchListDeletable)this.client(Pod.class).withLabel("camel.apache.org/integration", projectName)).waitUntilCondition(it -> "Running".equals(it.getStatus().getPhase()), 10L, TimeUnit.MINUTES);
        }
        if (this.dev || this.logs) {
            PodLogs logsCommand = new PodLogs(this.getMain());
            logsCommand.withClient(this.client());
            logsCommand.label = "%s=%s".formatted("camel.apache.org/integration", projectName);
            logsCommand.doCall();
        }
        return 0;
    }

    private KubernetesExport configureExport(String workingDir) {
        KubernetesExport.ExportConfigurer configurer = new KubernetesExport.ExportConfigurer(this.runtime, this.quarkusVersion, List.of(this.filePaths), this.gav, this.repositories, this.dependencies, this.excludes, this.mavenSettings, this.mavenSettingsSecurity, this.mavenCentralEnabled, this.mavenApacheSnapshotEnabled, this.javaVersion, this.camelVersion, this.kameletsVersion, this.profile, this.localKameletDir, this.springBootVersion, this.camelSpringBootVersion, this.quarkusGroupId, this.quarkusArtifactId, "maven", this.openApi, workingDir, this.packageName, this.buildProperties, true, false, false, true, false, true, true, false, false, "off");
        KubernetesExport export = new KubernetesExport(this.getMain(), configurer);
        export.image = this.image;
        export.imageRegistry = this.imageRegistry;
        export.imageGroup = this.imageGroup;
        export.imageBuilder = this.imageBuilder;
        export.clusterType = this.clusterType;
        export.traitProfile = this.traitProfile;
        export.serviceAccount = this.serviceAccount;
        export.properties = this.properties;
        export.configs = this.configs;
        export.resources = this.resources;
        export.envVars = this.envVars;
        export.volumes = this.volumes;
        export.connects = this.connects;
        export.annotations = this.annotations;
        export.labels = this.labels;
        export.traits = this.traits;
        return export;
    }

    private void installShutdownInterceptor(String projectName, String workingDir) {
        KubernetesDelete deleteCommand = new KubernetesDelete(this.getMain());
        deleteCommand.name = projectName;
        deleteCommand.workingDir = workingDir;
        Thread task = new Thread(() -> {
            try {
                deleteCommand.doCall();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        task.setName(ThreadHelper.resolveThreadName(null, (String)"CamelShutdownInterceptor"));
        Runtime.getRuntime().addShutdownHook(task);
    }

    private Integer buildQuarkus(String workingDir) throws IOException, InterruptedException {
        this.printer().println("Building Quarkus application ...");
        String mvnw = "/mvnw";
        if (FileUtil.isWindows()) {
            mvnw = "/mvnw.cmd";
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(workingDir + mvnw);
        args.add("--quiet");
        args.add("--file");
        args.add(workingDir);
        args.add("package");
        pb.command((String[])args.toArray(String[]::new));
        pb.inheritIO();
        Process p = pb.start();
        int exit = p.waitFor();
        if (exit != 0) {
            this.printer().println("Build failed!");
            return exit;
        }
        return 0;
    }

    private Integer deployQuarkus(String workingDir) throws IOException, InterruptedException {
        this.printer().println("Deploying to %s ...".formatted(Optional.ofNullable(this.clusterType).map(StringHelper::capitalize).orElse("Kubernetes")));
        String mvnw = "/mvnw";
        if (FileUtil.isWindows()) {
            mvnw = "/mvnw.cmd";
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(workingDir + mvnw);
        args.add("--quiet");
        args.add("--file");
        args.add(workingDir);
        if (this.imagePlatforms != null) {
            args.add("-Dquarkus.jib.platforms=%s".formatted(this.imagePlatforms));
        }
        if (this.imageBuild) {
            args.add("-Dquarkus.container-image.build=true");
        }
        if (this.imagePush) {
            args.add("-Dquarkus.container-image.push=true");
        }
        if (ClusterType.OPENSHIFT.isEqualTo(this.clusterType)) {
            args.add("-Dquarkus.openshift.deploy=true");
        } else {
            args.add("-Dquarkus.kubernetes.deploy=true");
        }
        if (this.namespace != null) {
            args.add("-Dquarkus.kubernetes.namespace=%s".formatted(this.namespace));
        }
        args.add("package");
        pb.command((String[])args.toArray(String[]::new));
        pb.inheritIO();
        Process p = pb.start();
        int exit = p.waitFor();
        if (exit != 0) {
            this.printer().println("Deployment failed!");
            return exit;
        }
        return 0;
    }

    private Integer buildSpringBoot(String workingDir) {
        this.printer().println("Building Spring Boot application ...");
        return 0;
    }

    private Integer deploySpringBoot(String workingDir) {
        this.printer().println("Deploying to %s ...".formatted(Optional.ofNullable(this.clusterType).map(StringHelper::capitalize).orElse("Kubernetes")));
        return 0;
    }

    private void configureFileWatch(DefaultCamelContext camelContext, String workingDir) throws Exception {
        String watchDir = ".";
        FileFilter filter = null;
        if (this.filePaths != null && this.filePaths.length > 0) {
            String filePath = FileUtil.onlyPath((String)SourceScheme.onlyName((String)this.filePaths[0]));
            if (filePath != null) {
                watchDir = filePath;
            }
            filter = pathname -> Arrays.stream(this.filePaths).map(FileUtil::stripPath).anyMatch(name -> name.equals(pathname.getName()));
        }
        FileWatcherResourceReloadStrategy reloadStrategy = new FileWatcherResourceReloadStrategy(watchDir);
        reloadStrategy.setResourceReload((name, resource) -> {
            this.printer().printf("Reloading project due to file change: %s%n", new Object[]{FileUtil.stripPath((String)name)});
            KubernetesExport export = this.configureExport(workingDir);
            int refresh = export.export();
            if (refresh == 0) {
                if (RuntimeType.quarkus == this.runtime) {
                    this.deployQuarkus(workingDir);
                } else if (RuntimeType.springBoot == this.runtime) {
                    this.deploySpringBoot(workingDir);
                }
            } else {
                this.printer().printf("Reloading project failed - export failed with code: %d%n", new Object[]{refresh});
            }
        });
        if (filter != null) {
            reloadStrategy.setFileFilter(filter);
        }
        camelContext.addService((Object)reloadStrategy);
    }

    private String getProjectName() {
        String[] ids;
        if (this.image != null) {
            return KubernetesHelper.sanitize(StringHelper.beforeLast((String)this.image, (String)":"));
        }
        if (this.gav != null && (ids = this.gav.split(":")).length > 1) {
            return KubernetesHelper.sanitize(ids[1]);
        }
        if (this.filePaths != null && this.filePaths.length > 0) {
            return KubernetesHelper.sanitize(FileUtil.onlyName((String)SourceScheme.onlyName((String)this.filePaths[0])));
        }
        throw new RuntimeCamelException("Failed to resolve project name - please provide --gav, --image option or at least one source file");
    }
}

