/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.ClusterType;
import org.apache.camel.dsl.jbang.core.common.YamlHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;
import org.yaml.snakeyaml.Yaml;

public final class KubernetesHelper {
    private static KubernetesClient kubernetesClient;
    private static final Map<String, KubernetesClient> clients;
    private static final ObjectMapper OBJECT_MAPPER;

    private KubernetesHelper() {
    }

    public static KubernetesClient getKubernetesClient() {
        if (kubernetesClient == null) {
            kubernetesClient = new KubernetesClientBuilder().build();
        }
        return kubernetesClient;
    }

    public static KubernetesClient getKubernetesClient(String config) {
        if (clients.containsKey(config)) {
            return clients.get(config);
        }
        return clients.put(config, new KubernetesClientBuilder().withConfig(config).build());
    }

    public static Yaml yaml() {
        return YamlHelper.yaml();
    }

    public static Yaml yaml(ClassLoader classLoader) {
        return YamlHelper.yaml((ClassLoader)classLoader);
    }

    public static ObjectMapper json() {
        return OBJECT_MAPPER;
    }

    public static String sanitize(String name) {
        name = FileUtil.onlyName((String)name);
        name = StringHelper.sanitize((String)name);
        name = StringHelper.camelCaseToDash((String)name);
        name = name.toLowerCase(Locale.US);
        name = name.replaceAll("[^a-z0-9-]", "");
        name = name.trim();
        return name;
    }

    public static void setKubernetesClient(KubernetesClient kubernetesClient) {
        KubernetesHelper.kubernetesClient = kubernetesClient;
    }

    public static String dumpYaml(Object model) {
        return KubernetesHelper.yaml().dumpAsMap(KubernetesHelper.json().convertValue(model, Map.class));
    }

    public static Map<String, Object> toJsonMap(Object model) {
        return (Map)KubernetesHelper.json().convertValue(model, Map.class);
    }

    public static File resolveKubernetesManifest(String workingDir) throws FileNotFoundException {
        return KubernetesHelper.resolveKubernetesManifest(new File(workingDir));
    }

    public static File resolveKubernetesManifest(String workingDir, String extension) throws FileNotFoundException {
        return KubernetesHelper.resolveKubernetesManifest(new File(workingDir), extension);
    }

    public static File resolveKubernetesManifest(File workingDir) throws FileNotFoundException {
        return KubernetesHelper.resolveKubernetesManifest(workingDir, "yml");
    }

    public static File resolveKubernetesManifest(File workingDir, String extension) throws FileNotFoundException {
        File manifest = KubernetesHelper.getKubernetesManifest(ClusterType.KUBERNETES.name(), workingDir);
        if (manifest.exists()) {
            return manifest;
        }
        return Arrays.stream(ClusterType.values()).filter(ct -> ct != ClusterType.KUBERNETES).map(ct -> KubernetesHelper.getKubernetesManifest(ct.name(), workingDir, extension)).filter(File::exists).findFirst().orElseThrow(() -> new FileNotFoundException("Unable to resolve Kubernetes manifest file type `%s` in folder: %s".formatted(extension, workingDir.toPath().toString())));
    }

    public static File getKubernetesManifest(String clusterType, String workingDir) {
        return KubernetesHelper.getKubernetesManifest(clusterType, new File(workingDir));
    }

    public static File getKubernetesManifest(String clusterType, File workingDir) {
        return KubernetesHelper.getKubernetesManifest(clusterType, workingDir, "yml");
    }

    public static File getKubernetesManifest(String clusterType, File workingDir, String extension) {
        String manifestFile = ClusterType.KIND.isEqualTo(clusterType) || ClusterType.MINIKUBE.isEqualTo(clusterType) ? "kubernetes" : Optional.ofNullable(clusterType).map(String::toLowerCase).orElse("kubernetes");
        return new File(workingDir, "%s.%s".formatted(manifestFile, extension));
    }

    static {
        clients = new HashMap<String, KubernetesClient>();
        OBJECT_MAPPER = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).enable(new DeserializationFeature[]{DeserializationFeature.READ_ENUMS_USING_TO_STRING})).enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY})).enable(new SerializationFeature[]{SerializationFeature.WRITE_ENUMS_USING_TO_STRING})).disable(new JsonParser.Feature[]{JsonParser.Feature.AUTO_CLOSE_SOURCE})).enable(new MapperFeature[]{MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})).build()).setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_EMPTY, (JsonInclude.Include)JsonInclude.Include.NON_EMPTY));
    }
}

