/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.Export;
import org.apache.camel.dsl.jbang.core.commands.ExportBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.CatalogHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.ClusterType;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitCatalog;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitProfile;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.RuntimeUtil;
import org.apache.camel.dsl.jbang.core.common.SourceHelper;
import org.apache.camel.util.CamelCaseOrderedProperties;
import org.apache.camel.util.StringHelper;
import org.apache.camel.v1.integrationspec.Traits;
import org.apache.camel.v1.integrationspec.traits.Container;
import picocli.CommandLine;

@CommandLine.Command(name="export", description={"Export as Maven/Gradle project that contains a Kubernetes deployment manifest"}, sortOptions=false)
public class KubernetesExport
extends Export {
    @CommandLine.Option(names={"--trait-profile"}, description={"The trait profile to use for the deployment."})
    protected String traitProfile;
    @CommandLine.Option(names={"--service-account"}, description={"The service account used to run the application."})
    protected String serviceAccount;
    @CommandLine.Option(names={"--property"}, description={"Add a runtime property or properties file from a path, a config map or a secret (syntax: [my-key=my-value|file:/path/to/my-conf.properties|[configmap|secret]:name])."})
    protected String[] properties;
    @CommandLine.Option(names={"--config"}, description={"Add a runtime configuration from a ConfigMap or a Secret (syntax: [configmap|secret]:name[/key], where name represents the configmap/secret name and key optionally represents the configmap/secret key to be filtered)."})
    protected String[] configs;
    @CommandLine.Option(names={"--resource"}, description={"Add a runtime resource from a Configmap or a Secret (syntax: [configmap|secret]:name[/key][@path], where name represents the configmap/secret name, key optionally represents the configmap/secret key to be filtered and path represents the destination path)."})
    protected String[] resources;
    @CommandLine.Option(names={"--env"}, description={"Set an environment variable in the integration container, for instance \"-e MY_VAR=my-value\"."})
    protected String[] envVars;
    @CommandLine.Option(names={"--volume"}, description={"Mount a volume into the integration container, for instance \"-v pvcname:/container/path\"."})
    protected String[] volumes;
    @CommandLine.Option(names={"--connect"}, description={"A Service that the integration should bind to, specified as [[apigroup/]version:]kind:[namespace/]name."})
    protected String[] connects;
    @CommandLine.Option(names={"--annotation"}, description={"Add an annotation to the integration. Use name values pairs like \"--annotation my.company=hello\"."})
    protected String[] annotations;
    @CommandLine.Option(names={"--label"}, description={"Add a label to the integration. Use name values pairs like \"--label my.company=hello\"."})
    protected String[] labels;
    @CommandLine.Option(names={"--trait"}, description={"Add a trait configuration to the integration. Use name values pairs like \"--trait trait.name.config=hello\"."})
    protected String[] traits;
    @CommandLine.Option(names={"--image"}, description={"The image name to be built."})
    protected String image;
    @CommandLine.Option(names={"--image-registry"}, description={"The image registry to hold the app container image."})
    protected String imageRegistry;
    @CommandLine.Option(names={"--image-group"}, description={"The image registry group used to push images to."})
    protected String imageGroup;
    @CommandLine.Option(names={"--image-builder"}, description={"The image builder used to build the container image (e.g. docker, jib, podman, s2i)."})
    protected String imageBuilder;
    @CommandLine.Option(names={"--cluster-type"}, description={"The target cluster type. Special configurations may be applied to different cluster types such as Kind or Minikube."})
    protected String clusterType;
    private static final String SRC_MAIN_RESOURCES = "/src/main/resources/";

    public KubernetesExport(CamelJBangMain main) {
        super(main);
    }

    public KubernetesExport(CamelJBangMain main, String[] files) {
        super(main);
        this.files = Arrays.asList(files);
    }

    public KubernetesExport(CamelJBangMain main, ExportConfigurer configurer) {
        super(main);
        this.runtime = configurer.runtime;
        this.quarkusVersion = configurer.quarkusVersion;
        this.files = configurer.files;
        this.gav = configurer.gav;
        this.repositories = configurer.repositories;
        this.dependencies = configurer.dependencies;
        this.excludes = configurer.excludes;
        this.mavenSettings = configurer.mavenSettings;
        this.mavenSettingsSecurity = configurer.mavenSettingsSecurity;
        this.mavenCentralEnabled = configurer.mavenCentralEnabled;
        this.mavenApacheSnapshotEnabled = configurer.mavenApacheSnapshotEnabled;
        this.javaVersion = configurer.javaVersion;
        this.camelVersion = configurer.camelVersion;
        this.kameletsVersion = configurer.kameletsVersion;
        this.profile = configurer.profile;
        this.localKameletDir = configurer.localKameletDir;
        this.springBootVersion = configurer.springBootVersion;
        this.camelSpringBootVersion = configurer.camelSpringBootVersion;
        this.quarkusGroupId = configurer.quarkusGroupId;
        this.quarkusArtifactId = configurer.quarkusArtifactId;
        this.buildTool = configurer.buildTool;
        this.openapi = configurer.openapi;
        this.exportDir = configurer.exportDir;
        this.packageName = configurer.packageName;
        this.buildProperties = configurer.buildProperties;
        this.symbolicLink = configurer.symbolicLink;
        this.javaLiveReload = configurer.javaLiveReload;
        this.ignoreLoadingError = configurer.ignoreLoadingError;
        this.mavenWrapper = configurer.mavenWrapper;
        this.gradleWrapper = configurer.gradleWrapper;
        this.fresh = configurer.fresh;
        this.download = configurer.download;
        this.quiet = configurer.quiet;
        this.logging = configurer.logging;
        this.loggingLevel = configurer.loggingLevel;
    }

    public Integer export() throws Exception {
        int exit;
        List sources;
        String resolvedImageRegistry;
        if (this.runtime == null) {
            this.runtime = RuntimeType.quarkus;
        }
        if (!this.buildTool.equals("maven")) {
            this.printer().printf("--build-tool=%s is not yet supported%n", new Object[]{this.buildTool});
        }
        String propPrefix = this.runtime == RuntimeType.springBoot ? "camel.springboot" : (this.runtime == RuntimeType.main ? "camel.main" : this.runtime.runtime());
        String resolvedImageGroup = this.resolveImageGroup();
        if (resolvedImageGroup != null) {
            this.buildProperties.add("%s.container-image.group=%s".formatted(propPrefix, resolvedImageGroup));
        }
        if ((resolvedImageRegistry = this.resolveImageRegistry()) != null) {
            boolean allowInsecure = resolvedImageRegistry.startsWith("localhost");
            this.buildProperties.add("%s.container-image.registry=%s".formatted(propPrefix, resolvedImageRegistry));
            this.buildProperties.add("%s.container-image.insecure=%b".formatted(propPrefix, allowInsecure));
        }
        String projectName = this.getProjectName();
        CamelCatalog catalog = CatalogHelper.loadCatalog(this.runtime, this.runtime.version());
        try {
            sources = SourceHelper.resolveSources((List)this.files);
        }
        catch (Exception e) {
            if (!this.quiet) {
                this.printer().printf("Project export failed: %s - %s%n", new Object[]{e.getMessage(), Optional.ofNullable(e.getCause()).map(Throwable::getMessage).orElse("unknown reason")});
            }
            return 1;
        }
        TraitContext context = new TraitContext(projectName, this.getVersion(), this.printer(), catalog, sources);
        this.annotations = Optional.ofNullable(this.annotations).orElse(new String[0]);
        context.addAnnotations(Arrays.stream(this.annotations).map(item -> item.split("=")).filter(parts -> ((String[])parts).length == 2).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1])));
        this.addLabel("app.kubernetes.io/runtime", "camel");
        context.addLabels(Arrays.stream(this.labels).map(item -> item.split("=")).filter(parts -> ((String[])parts).length == 2).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1])));
        if (this.traitProfile != null) {
            context.setProfile(TraitProfile.valueOf(this.traitProfile.toUpperCase()));
        }
        if (this.serviceAccount != null) {
            context.setServiceAccount(this.serviceAccount);
        }
        String[] applicationProperties = this.extractPropertiesTraits(new File("application.properties"));
        String[] applicationProfileProperties = null;
        if (this.profile != null) {
            applicationProfileProperties = this.extractPropertiesTraits(new File("application-" + this.profile + ".properties"));
        }
        Traits traitsSpec = this.getTraitSpec(applicationProperties, applicationProfileProperties);
        TraitHelper.configureMountTrait(traitsSpec, this.configs, this.resources, this.volumes);
        if (this.openapi != null && this.openapi.startsWith("configmap:")) {
            TraitHelper.configureOpenApiSpec(traitsSpec, this.openapi);
            this.openapi = null;
        }
        TraitHelper.configureProperties(traitsSpec, this.properties);
        TraitHelper.configureContainerImage(traitsSpec, this.image, resolvedImageRegistry, resolvedImageGroup, projectName, this.getVersion());
        TraitHelper.configureEnvVars(traitsSpec, this.envVars);
        TraitHelper.configureConnects(traitsSpec, this.connects);
        Container container = traitsSpec.getContainer();
        this.buildProperties.add("%s.kubernetes.image-name=%s".formatted(propPrefix, container.getImage()));
        this.buildProperties.add("%s.kubernetes.ports.%s.container-port=%d".formatted(propPrefix, Optional.ofNullable(container.getPortName()).orElse("http"), Optional.ofNullable(container.getPort()).map(Long::intValue).orElse(8080)));
        if (container.getName() != null && !container.getName().equals(projectName)) {
            this.buildProperties.add("%s.kubernetes.container-name=%s".formatted(propPrefix, container.getName()));
        }
        if (container.getImagePullPolicy() != null) {
            String imagePullPolicy = container.getImagePullPolicy().getValue();
            if (this.runtime == RuntimeType.quarkus) {
                imagePullPolicy = StringHelper.camelCaseToDash((String)imagePullPolicy);
            }
            this.buildProperties.add("%s.kubernetes.image-pull-policy=%s".formatted(propPrefix, imagePullPolicy));
        }
        if (this.runtime == RuntimeType.quarkus) {
            if (ClusterType.OPENSHIFT.isEqualTo(this.clusterType)) {
                this.addDependencies(new String[]{"io.quarkus:quarkus-openshift"});
            } else {
                this.addDependencies(new String[]{"io.quarkus:quarkus-kubernetes"});
                if (this.imageBuilder == null) {
                    this.imageBuilder = "jib";
                }
            }
            if ("s2i".equals(this.imageBuilder)) {
                this.imageBuilder = "openshift";
            }
            if (this.imageBuilder != null) {
                this.addDependencies(new String[]{"io.quarkus:quarkus-container-image-%s".formatted(this.imageBuilder)});
                this.buildProperties.add("quarkus.container-image.builder=%s".formatted(this.imageBuilder));
            }
            this.buildProperties.add("quarkus.container-image.build=true");
        }
        if (this.runtime == RuntimeType.springBoot || this.runtime == RuntimeType.main) {
            File settings = new File(CommandLineHelper.getWorkDir(), "camel-jbang-run.properties");
            String jkubeVersion = KubernetesExport.jkubeMavenPluginVersion((File)settings, (Properties)this.mapBuildProperties());
            this.buildProperties.add("%s.jkube.version=%s".formatted(propPrefix, jkubeVersion));
        }
        if ((exit = super.export().intValue()) != 0) {
            if (!this.quiet) {
                this.printer().println("Project export failed");
            }
            return exit;
        }
        if (!this.quiet) {
            this.printer().println("Building Kubernetes manifest ...");
        }
        new TraitCatalog().apply(traitsSpec, context, this.traitProfile);
        List<Map> kubeFragments = context.buildItems().stream().map(KubernetesHelper::toJsonMap).toList();
        if (this.runtime == RuntimeType.quarkus) {
            String kubeManifest = kubeFragments.stream().map(KubernetesHelper::dumpYaml).collect(Collectors.joining("---\n"));
            this.safeCopy(new ByteArrayInputStream(kubeManifest.getBytes(StandardCharsets.UTF_8)), KubernetesHelper.getKubernetesManifest(this.clusterType, this.exportDir + "/src/main/kubernetes"));
        }
        if (this.runtime == RuntimeType.springBoot || this.runtime == RuntimeType.main) {
            for (Map map : kubeFragments) {
                String ymlFragment = KubernetesHelper.dumpYaml(map);
                String kind = map.get("kind").toString().toLowerCase();
                this.safeCopy(new ByteArrayInputStream(ymlFragment.getBytes(StandardCharsets.UTF_8)), new File(this.exportDir + "/src/main/jkube/%s.yml".formatted(kind)));
            }
        }
        context.doWithConfigurationResources((fileName, content) -> {
            block4: {
                try {
                    File target = new File(this.exportDir + SRC_MAIN_RESOURCES + fileName);
                    if (target.exists()) {
                        Files.writeString(target.toPath(), (CharSequence)"%n%s".formatted(content), StandardOpenOption.APPEND);
                    } else {
                        this.safeCopy(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), target);
                    }
                }
                catch (Exception e) {
                    if (this.quiet) break block4;
                    this.printer().printf("Failed to create configuration resource %s - %s%n", new Object[]{this.exportDir + SRC_MAIN_RESOURCES + fileName, e.getMessage()});
                }
            }
        });
        if (!this.quiet) {
            this.printer().println("Project export successful!");
        }
        return 0;
    }

    protected Integer export(ExportBaseCommand cmd) throws Exception {
        if (this.runtime == RuntimeType.springBoot) {
            cmd.pomTemplateName = "spring-boot-kubernetes-pom.tmpl";
        }
        if (this.runtime == RuntimeType.main) {
            cmd.pomTemplateName = "main-kubernetes-pom.tmpl";
        }
        return super.export(cmd);
    }

    protected Traits getTraitSpec(String[] applicationProperties, String[] applicationProfileProperties) {
        String[] annotationsTraits = TraitHelper.extractTraitsFromAnnotations(this.annotations);
        String[] allTraits = TraitHelper.mergeTraits(this.traits, annotationsTraits, applicationProfileProperties, applicationProperties);
        Traits traitsSpec = allTraits != null && allTraits.length > 0 ? TraitHelper.parseTraits(allTraits) : new Traits();
        return traitsSpec;
    }

    private void addLabel(String key, String value) {
        String[] labelArray = Optional.ofNullable(this.labels).orElse(new String[0]);
        ArrayList<String> labelList = new ArrayList<String>(Arrays.asList(labelArray));
        labelList.add("%s=%s".formatted(key, value));
        this.labels = labelList.toArray(new String[0]);
    }

    private String resolveImageGroup() {
        if (this.image != null) {
            return this.extractImageGroup(this.image);
        }
        if (this.imageGroup != null) {
            return this.imageGroup;
        }
        if (this.gav != null) {
            String groupId = KubernetesExport.parseMavenGav((String)this.gav).getGroupId();
            String[] dotToks = groupId.split("\\.");
            return dotToks[dotToks.length - 1];
        }
        return null;
    }

    private String resolveImageRegistry() {
        if (this.image != null) {
            return this.extractImageRegistry(this.image);
        }
        if (this.imageRegistry != null) {
            if (this.imageRegistry.equals("kind") || this.imageRegistry.equals("kind-registry")) {
                return "localhost:5001";
            }
            if (this.imageRegistry.equals("minikube") || this.imageRegistry.equals("minikube-registry")) {
                return "localhost:5000";
            }
            return this.imageRegistry;
        }
        if (ClusterType.KIND.isEqualTo(this.clusterType)) {
            return "localhost:5001";
        }
        if (ClusterType.MINIKUBE.isEqualTo(this.clusterType)) {
            return "localhost:5000";
        }
        return null;
    }

    private String extractImageGroup(String image) {
        String[] parts = image.split("/");
        if (parts.length == 3) {
            return parts[1];
        }
        if (parts.length > 1) {
            return parts[0];
        }
        return this.imageGroup;
    }

    private String extractImageRegistry(String image) {
        String[] parts = image.split("/");
        if (parts.length == 3) {
            return parts[0];
        }
        return this.imageRegistry;
    }

    protected String[] extractPropertiesTraits(File file) throws Exception {
        if (file.exists()) {
            CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
            RuntimeUtil.loadProperties((Properties)prop, (File)file);
            return TraitHelper.extractTraitsFromProperties((Properties)prop);
        }
        return null;
    }

    protected String getProjectName() {
        if (this.image != null) {
            return KubernetesHelper.sanitize(KubernetesHelper.sanitize(StringHelper.beforeLast((String)this.image, (String)":")));
        }
        return KubernetesHelper.sanitize(super.getProjectName());
    }

    protected String getVersion() {
        if (this.image != null) {
            return StringHelper.afterLast((String)this.image, (String)":");
        }
        return super.getVersion();
    }

    public record ExportConfigurer(RuntimeType runtime, String quarkusVersion, List<String> files, String gav, List<String> repositories, List<String> dependencies, List<String> excludes, String mavenSettings, String mavenSettingsSecurity, boolean mavenCentralEnabled, boolean mavenApacheSnapshotEnabled, String javaVersion, String camelVersion, String kameletsVersion, String profile, String localKameletDir, String springBootVersion, String camelSpringBootVersion, String quarkusGroupId, String quarkusArtifactId, String buildTool, String openapi, String exportDir, String packageName, List<String> buildProperties, boolean symbolicLink, boolean javaLiveReload, boolean ignoreLoadingError, boolean mavenWrapper, boolean gradleWrapper, boolean fresh, boolean download, boolean quiet, boolean logging, String loggingLevel) {
    }
}

