/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesHelper;
import picocli.CommandLine;

public abstract class KubernetesBaseCommand
extends CamelCommand {
    static final String RUN_PLATFORM_DIR = ".camel-jbang-run";
    @CommandLine.Option(names={"--kube-config"}, description={"Path to the kube config file to initialize Kubernetes client"})
    String kubeConfig;
    @CommandLine.Option(names={"--namespace", "-n"}, description={"Namespace to use for all operations"})
    String namespace;
    private KubernetesClient kubernetesClient;

    public KubernetesBaseCommand(CamelJBangMain main) {
        super(main);
    }

    protected <T extends HasMetadata> NonNamespaceOperation<T, KubernetesResourceList<T>, Resource<T>> client(Class<T> resourceType) {
        if (this.namespace != null) {
            return (NonNamespaceOperation)this.client().resources(resourceType).inNamespace(this.namespace);
        }
        return this.client().resources(resourceType);
    }

    protected NonNamespaceOperation<Pod, PodList, PodResource> pods() {
        if (this.namespace != null) {
            return (NonNamespaceOperation)this.client().pods().inNamespace(this.namespace);
        }
        return this.client().pods();
    }

    protected KubernetesClient client() {
        if (this.kubernetesClient == null) {
            if (this.kubeConfig != null) {
                this.kubernetesClient = KubernetesHelper.getKubernetesClient(this.kubeConfig);
            }
            this.kubernetesClient = KubernetesHelper.getKubernetesClient();
        }
        return this.kubernetesClient;
    }

    public KubernetesBaseCommand withClient(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
        return this;
    }
}

