/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.dsl.jbang.core.common.CatalogLoader;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;

public class CatalogHelper {
    private CatalogHelper() {
    }

    public static CamelCatalog loadCatalog(RuntimeType runtime, String runtimeVersion) throws Exception {
        return CatalogHelper.loadCatalog(runtime, runtimeVersion, "", null);
    }

    public static CamelCatalog loadCatalog(RuntimeType runtime, String runtimeVersion, String repos, String quarkusGroupId) throws Exception {
        switch (runtime) {
            case springBoot: {
                return CatalogLoader.loadSpringBootCatalog((String)repos, (String)runtimeVersion);
            }
            case quarkus: {
                return CatalogLoader.loadQuarkusCatalog((String)repos, (String)runtimeVersion, (String)quarkusGroupId);
            }
            case main: {
                return CatalogLoader.loadCatalog((String)repos, (String)runtimeVersion);
            }
        }
        throw new IllegalArgumentException("Unsupported runtime: " + String.valueOf(runtime));
    }
}

