/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.java.joor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dsl.java.joor.ByteArrayClassLoader;
import org.apache.camel.dsl.support.ExtendedRouteBuilderLoaderSupport;
import org.apache.camel.spi.CompilePostProcessor;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceAware;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed ClassRoutesBuilderLoader")
@RoutesLoader(value="class")
public class ClassRoutesBuilderLoader
extends ExtendedRouteBuilderLoaderSupport {
    public static final String EXTENSION = "class";
    private static final Logger LOG = LoggerFactory.getLogger(ClassRoutesBuilderLoader.class);

    public ClassRoutesBuilderLoader() {
        super(EXTENSION);
    }

    protected Collection<RoutesBuilder> doLoadRoutesBuilders(Collection<Resource> resources) throws Exception {
        ArrayList<RoutesBuilder> answer = new ArrayList<RoutesBuilder>();
        LOG.debug("Loading .class resources from: {}", resources);
        LinkedHashMap<String, byte[]> byteCodes = new LinkedHashMap<String, byte[]>();
        for (Resource res : resources) {
            String className = ClassRoutesBuilderLoader.asClassName(res);
            InputStream is = res.getInputStream();
            if (is == null) continue;
            byte[] code = is.readAllBytes();
            byteCodes.put(className, code);
        }
        ByteArrayClassLoader cl = new ByteArrayClassLoader(byteCodes);
        for (Resource res : resources) {
            Object obj;
            String className = ClassRoutesBuilderLoader.asClassName(res);
            Class<?> clazz = cl.findClass(className);
            try {
                obj = this.getCamelContext().getInjector().newInstance(clazz);
            }
            catch (Exception e) {
                LOG.debug("Loaded class {} must have a default no-arg constructor. Skipping.", (Object)className);
                continue;
            }
            CamelContextAware.trySetCamelContext((Object)obj, (CamelContext)this.getCamelContext());
            ResourceAware.trySetResource((Object)obj, (Resource)res);
            for (CompilePostProcessor pre : this.getCompilePostProcessors()) {
                pre.postCompile(this.getCamelContext(), className, clazz, null, obj);
            }
            if (!(obj instanceof RouteBuilder)) continue;
            RouteBuilder builder = (RouteBuilder)obj;
            answer.add((RoutesBuilder)builder);
        }
        return answer;
    }

    private static String asClassName(Resource resource) {
        String className = resource.getLocation();
        if (className.contains(":")) {
            className = StringHelper.after((String)className, (String)":");
        }
        if ((className = className.replace('/', '.')).endsWith(".class")) {
            className = className.substring(0, className.length() - 6);
        }
        return className;
    }
}

