/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jasypt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;

public class Main {
    private final StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
    private final List<Option> options = new ArrayList<Option>();
    private String command;
    private String password;
    private String input;
    private String algorithm;

    public Main() {
        this.addOption(new Option("h", "help", "Displays the help screen"){

            @Override
            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                Main.this.showOptions();
                System.exit(0);
            }
        });
        this.addOption(new ParameterOption("c", "command", "Command can be encrypt or decrypt", "command"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                if (!"encrypt".equals(parameter) && !"decrypt".equals(parameter)) {
                    throw new IllegalArgumentException("Unknown command, was: " + parameter);
                }
                Main.this.command = parameter;
            }
        });
        this.addOption(new ParameterOption("p", "password", "Password to use", "password"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.password = parameter;
            }
        });
        this.addOption(new ParameterOption("i", "input", "Text to encrypt or decrypt", "input"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.input = parameter;
            }
        });
        this.addOption(new ParameterOption("a", "algorithm", "Optional algorithm to use", "algorithm"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.algorithm = parameter;
            }
        });
    }

    private void addOption(Option option) {
        this.options.add(option);
    }

    private void showOptions() {
        System.out.println("Apache Camel Jasypt takes the following options:");
        System.out.println();
        for (Option option : this.options) {
            System.out.println(option.getInformation());
        }
        System.out.println();
        System.out.println();
    }

    private boolean parseArguments(String[] arguments) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(arguments));
        boolean valid = true;
        while (!args.isEmpty()) {
            String arg = args.removeFirst();
            boolean handled = false;
            for (Option option : this.options) {
                if (!option.processOption(arg, args)) continue;
                handled = true;
                break;
            }
            if (handled) continue;
            System.out.println("Error: Unknown option: " + arg);
            System.out.println();
            valid = false;
            break;
        }
        return valid;
    }

    public void run(String[] args) throws Exception {
        if (!this.parseArguments(args)) {
            this.showOptions();
            return;
        }
        if (this.command == null) {
            System.out.println("Error: Command is empty");
            System.out.println();
            this.showOptions();
            return;
        }
        if (this.password == null) {
            System.out.println("Error: Password is empty");
            System.out.println();
            this.showOptions();
            return;
        }
        if (this.input == null) {
            System.out.println("Error: Input is empty");
            System.out.println();
            this.showOptions();
            return;
        }
        this.encryptor.setPassword(this.password);
        if (this.algorithm != null) {
            this.encryptor.setAlgorithm(this.algorithm);
        }
        if ("encrypt".equals(this.command)) {
            System.out.println("Encrypted text: " + this.encryptor.encrypt(this.input));
        } else {
            System.out.println("Decrypted text: " + this.encryptor.decrypt(this.input));
        }
    }

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        if (args.length == 0) {
            main.showOptions();
            return;
        }
        main.run(args);
    }

    private abstract class ParameterOption
    extends Option {
        private String parameterName;

        protected ParameterOption(String abbreviation, String fullName, String description, String parameterName) {
            super(abbreviation, fullName, description);
            this.parameterName = parameterName;
        }

        @Override
        protected void doProcess(String arg, LinkedList<String> remainingArgs) {
            if (remainingArgs.isEmpty()) {
                System.err.println("Expected fileName for ");
                Main.this.showOptions();
            } else {
                String parameter = remainingArgs.removeFirst();
                this.doProcess(arg, parameter, remainingArgs);
            }
        }

        @Override
        public String getInformation() {
            return "  " + this.getAbbreviation() + " or " + this.getFullName() + " <" + this.parameterName + "> = " + this.getDescription();
        }

        protected abstract void doProcess(String var1, String var2, LinkedList<String> var3);
    }

    private abstract class Option {
        private String abbreviation;
        private String fullName;
        private String description;

        protected Option(String abbreviation, String fullName, String description) {
            this.abbreviation = "-" + abbreviation;
            this.fullName = "-" + fullName;
            this.description = description;
        }

        public boolean processOption(String arg, LinkedList<String> remainingArgs) {
            if (arg.equalsIgnoreCase(this.abbreviation) || this.fullName.startsWith(arg)) {
                this.doProcess(arg, remainingArgs);
                return true;
            }
            return false;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getInformation() {
            return "  " + this.getAbbreviation() + " or " + this.getFullName() + " = " + this.getDescription();
        }

        protected abstract void doProcess(String var1, LinkedList<String> var2);
    }
}

