/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.transform;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.jackson.SchemaHelper;
import org.apache.camel.component.jackson.transform.Json;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.MimeType;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="application-x-struct", description="Transforms to generic JSonNode using Jackson")
public class JsonStructDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        if (message.getBody() instanceof JsonNode) {
            return;
        }
        try {
            Object unmarshalled;
            String contentClass = SchemaHelper.resolveContentClass(message.getExchange(), null);
            if (contentClass != null) {
                Class contentType = message.getExchange().getContext().getClassResolver().resolveMandatoryClass(contentClass);
                unmarshalled = Json.mapper().reader().forType(JsonNode.class).readValue(Json.mapper().writerFor(contentType).writeValueAsString(message.getBody()));
            } else {
                unmarshalled = Json.mapper().reader().forType(JsonNode.class).readValue(this.getBodyAsStream(message));
            }
            message.setBody(unmarshalled);
            message.setHeader("Content-Type", (Object)MimeType.STRUCT.type());
        }
        catch (IOException | ClassNotFoundException | InvalidPayloadException e) {
            throw new CamelExecutionException("Failed to apply Json input data type on exchange", message.getExchange(), e);
        }
    }

    private InputStream getBodyAsStream(Message message) throws InvalidPayloadException {
        if (message.getBody() == null) {
            return new ByteArrayInputStream("{}".getBytes(StandardCharsets.UTF_8));
        }
        InputStream bodyStream = (InputStream)message.getBody(InputStream.class);
        if (bodyStream == null) {
            bodyStream = new ByteArrayInputStream((byte[])message.getMandatoryBody(byte[].class));
        }
        return bodyStream;
    }
}

