/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.jackson.converter.JacksonTypeConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class JacksonTypeConvertersLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;
    private volatile JacksonTypeConverters jacksonTypeConverters;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
        this.registerFallbackConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        JacksonTypeConvertersLoader.addTypeConverter(registry, byte[].class, JsonNode.class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toByteArray((JsonNode)value, exchange));
        JacksonTypeConvertersLoader.addTypeConverter(registry, JsonNode.class, byte[].class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toJsonNode((byte[])value, exchange));
        JacksonTypeConvertersLoader.addTypeConverter(registry, JsonNode.class, File.class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toJsonNode((File)value, exchange));
        JacksonTypeConvertersLoader.addTypeConverter(registry, JsonNode.class, InputStream.class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toJsonNode((InputStream)value, exchange));
        JacksonTypeConvertersLoader.addTypeConverter(registry, JsonNode.class, Reader.class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toJsonNode((Reader)value, exchange));
        JacksonTypeConvertersLoader.addTypeConverter(registry, JsonNode.class, String.class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toJsonNode((String)value, exchange));
        JacksonTypeConvertersLoader.addTypeConverter(registry, JsonNode.class, Map.class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toJsonNode((Map)value, exchange));
        JacksonTypeConvertersLoader.addTypeConverter(registry, InputStream.class, JsonNode.class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toInputStream((JsonNode)value, exchange));
        JacksonTypeConvertersLoader.addTypeConverter(registry, Reader.class, JsonNode.class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toReader((JsonNode)value, exchange));
        JacksonTypeConvertersLoader.addTypeConverter(registry, Boolean.class, JsonNode.class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toBoolean((JsonNode)value, exchange));
        JacksonTypeConvertersLoader.addTypeConverter(registry, Boolean.class, BooleanNode.class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toBoolean((BooleanNode)value, exchange));
        JacksonTypeConvertersLoader.addTypeConverter(registry, Double.class, JsonNode.class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toDouble((JsonNode)value, exchange));
        JacksonTypeConvertersLoader.addTypeConverter(registry, Float.class, JsonNode.class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toFloat((JsonNode)value, exchange));
        JacksonTypeConvertersLoader.addTypeConverter(registry, Integer.class, JsonNode.class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toInteger((JsonNode)value, exchange));
        JacksonTypeConvertersLoader.addTypeConverter(registry, Long.class, JsonNode.class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toLong((JsonNode)value, exchange));
        JacksonTypeConvertersLoader.addTypeConverter(registry, String.class, JsonNode.class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toString((JsonNode)value, exchange));
        JacksonTypeConvertersLoader.addTypeConverter(registry, Map.class, JsonNode.class, false, (type, exchange, value) -> this.getJacksonTypeConverters().toMap((JsonNode)value, exchange));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        JacksonTypeConvertersLoader.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> this.getJacksonTypeConverters().convertTo(type, exchange, value, registry));
    }

    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter((TypeConverter)new SimpleTypeConverter(allowNull, method), canPromote);
    }

    private JacksonTypeConverters getJacksonTypeConverters() {
        if (this.jacksonTypeConverters == null) {
            this.jacksonTypeConverters = new JacksonTypeConverters();
            CamelContextAware.trySetCamelContext((Object)this.jacksonTypeConverters, (CamelContext)this.camelContext);
        }
        return this.jacksonTypeConverters;
    }
}

