/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.transform;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.nio.charset.StandardCharsets;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Message;
import org.apache.camel.component.jackson.SchemaHelper;
import org.apache.camel.component.jackson.transform.Json;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.MimeType;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="application-json", description="Transforms from JSon to binary (byte array) using Jackson")
public class JsonDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        try {
            byte[] marshalled;
            String jsonString;
            Object object = message.getBody();
            if (object instanceof String && Json.isJson(jsonString = (String)object)) {
                marshalled = jsonString.getBytes(StandardCharsets.UTF_8);
            } else {
                String contentClass = SchemaHelper.resolveContentClass(message.getExchange(), JsonNode.class.getName());
                Class contentType = message.getExchange().getContext().getClassResolver().resolveMandatoryClass(contentClass);
                marshalled = Json.mapper().writer().forType(contentType).writeValueAsBytes(message.getBody());
            }
            message.setBody((Object)marshalled);
            message.setHeader("Content-Type", (Object)MimeType.JSON.type());
            String contentSchema = (String)message.getExchange().getProperty("X-Content-Schema", String.class);
            if (contentSchema != null) {
                message.setHeader("X-Content-Schema", (Object)contentSchema);
            }
        }
        catch (JsonProcessingException | ClassNotFoundException e) {
            throw new CamelExecutionException("Failed to apply Json output data type on exchange", message.getExchange(), e);
        }
    }
}

