/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class IrcEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":hostname:port";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "irc".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "hostname", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "port", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(29);
        props.add("autoRejoin");
        props.add("bridgeErrorHandler");
        props.add("channels");
        props.add("colors");
        props.add("commandTimeout");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("hostname");
        props.add("keys");
        props.add("lazyStartProducer");
        props.add("namesOnJoin");
        props.add("nickPassword");
        props.add("nickname");
        props.add("onJoin");
        props.add("onKick");
        props.add("onMode");
        props.add("onNick");
        props.add("onPart");
        props.add("onPrivmsg");
        props.add("onQuit");
        props.add("onReply");
        props.add("onTopic");
        props.add("password");
        props.add("persistent");
        props.add("port");
        props.add("realname");
        props.add("sslContextParameters");
        props.add("trustManager");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(3);
        secretProps.add("nickPassword");
        secretProps.add("password");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

