/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.util.ObjectHelper;
import org.schwering.irc.lib.ssl.SSLDefaultTrustManager;
import org.schwering.irc.lib.ssl.SSLTrustManager;

public class IrcConfiguration
implements Cloneable {
    private String target;
    private List<String> channels = new ArrayList<String>();
    private Dictionary<String, String> keys = new Hashtable<String, String>();
    private String hostname;
    private String password;
    private String nickname;
    private String realname;
    private String username;
    private SSLTrustManager trustManager = new SSLDefaultTrustManager();
    private boolean usingSSL;
    private boolean persistent = true;
    private boolean colors = true;
    private boolean onNick = true;
    private boolean onQuit = true;
    private boolean onJoin = true;
    private boolean onKick = true;
    private boolean onMode = true;
    private boolean onPart = true;
    private boolean onReply;
    private boolean onTopic = true;
    private boolean onPrivmsg = true;
    private boolean autoRejoin = true;
    private int[] ports = new int[]{6667, 6668, 6669};
    private String channelKeys;

    public IrcConfiguration() {
    }

    public IrcConfiguration(String hostname, String nickname, String displayname, List<String> channels) {
        this.channels = channels;
        this.hostname = hostname;
        this.nickname = nickname;
        this.username = nickname;
        this.realname = displayname;
    }

    public IrcConfiguration(String hostname, String username, String password, String nickname, String displayname, List<String> channels) {
        this.channels = channels;
        this.hostname = hostname;
        this.username = username;
        this.password = password;
        this.nickname = nickname;
        this.realname = displayname;
    }

    public IrcConfiguration copy() {
        try {
            return (IrcConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public String getCacheKey() {
        return this.hostname + ":" + this.nickname;
    }

    public String getListOfChannels() {
        String retval = "";
        for (String channel : this.channels) {
            retval = retval + channel + " ";
        }
        return retval.trim();
    }

    public void configure(String uriStr) throws URISyntaxException {
        if (uriStr.startsWith("ircs")) {
            this.setUsingSSL(true);
            if (!uriStr.startsWith("ircs://")) {
                uriStr = uriStr.replace("ircs:", "ircs://");
            }
        } else if (!uriStr.startsWith("irc://")) {
            uriStr = uriStr.replace("irc:", "irc://");
        }
        if (uriStr.contains("?")) {
            uriStr = ObjectHelper.before((String)uriStr, (String)"?");
        }
        URI uri = new URI(uriStr);
        this.setNickname(uri.getUserInfo());
        this.setUsername(uri.getUserInfo());
        this.setRealname(uri.getUserInfo());
        this.setHostname(uri.getHost());
        if (uri.getFragment() != null && uri.getFragment().length() != 0) {
            String channel = "#" + uri.getFragment();
            this.addChannel(channel);
        }
    }

    public void addChannel(String channel) {
        boolean alreadyHave = false;
        for (String aChannel : this.channels) {
            if (!channel.contentEquals(aChannel)) continue;
            alreadyHave = true;
        }
        if (!alreadyHave) {
            this.channels.add(channel);
        }
    }

    public void setChannels(String channels) {
        String[] args;
        for (String channel : args = channels.split(",")) {
            if (!(channel = channel.trim()).startsWith("#")) continue;
            this.addChannel(channel);
        }
        if (this.keys.size() == 0 && this.channelKeys != null) {
            this.setKeys(this.channelKeys);
        }
    }

    public void setKeys(String keys) {
        if (this.channels.size() == 0) {
            this.channelKeys = keys;
        } else {
            String[] s = keys.split(",");
            int index = 0;
            for (String key : s) {
                this.keys.put(this.channels.get(index), key);
                ++index;
            }
        }
    }

    public String getKey(String channel) {
        return this.keys.get(channel);
    }

    public Dictionary<String, String> getKeys() {
        return this.keys;
    }

    public void setTrustManager(SSLTrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public SSLTrustManager getTrustManager() {
        return this.trustManager;
    }

    public boolean getUsingSSL() {
        return this.usingSSL;
    }

    private void setUsingSSL(boolean usingSSL) {
        this.usingSSL = usingSSL;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getRealname() {
        return this.realname;
    }

    public void setRealname(String realname) {
        this.realname = realname;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public int[] getPorts() {
        return this.ports;
    }

    public void setPorts(int[] ports) {
        this.ports = ports;
    }

    public List<String> getChannels() {
        return this.channels;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isColors() {
        return this.colors;
    }

    public void setColors(boolean colors) {
        this.colors = colors;
    }

    public boolean isOnNick() {
        return this.onNick;
    }

    public void setOnNick(boolean onNick) {
        this.onNick = onNick;
    }

    public boolean isOnQuit() {
        return this.onQuit;
    }

    public void setOnQuit(boolean onQuit) {
        this.onQuit = onQuit;
    }

    public boolean isOnJoin() {
        return this.onJoin;
    }

    public void setOnJoin(boolean onJoin) {
        this.onJoin = onJoin;
    }

    public boolean isOnKick() {
        return this.onKick;
    }

    public void setOnKick(boolean onKick) {
        this.onKick = onKick;
    }

    public boolean isOnMode() {
        return this.onMode;
    }

    public void setOnMode(boolean onMode) {
        this.onMode = onMode;
    }

    public boolean isOnPart() {
        return this.onPart;
    }

    public void setOnPart(boolean onPart) {
        this.onPart = onPart;
    }

    public boolean isOnReply() {
        return this.onReply;
    }

    public void setOnReply(boolean onReply) {
        this.onReply = onReply;
    }

    public boolean isOnTopic() {
        return this.onTopic;
    }

    public void setOnTopic(boolean onTopic) {
        this.onTopic = onTopic;
    }

    public boolean isOnPrivmsg() {
        return this.onPrivmsg;
    }

    public void setOnPrivmsg(boolean onPrivmsg) {
        this.onPrivmsg = onPrivmsg;
    }

    public boolean isAutoRejoin() {
        return this.autoRejoin;
    }

    public void setAutoRejoin(boolean autoRejoin) {
        this.autoRejoin = autoRejoin;
    }

    public String toString() {
        return "IrcConfiguration[hostname: " + this.hostname + ", ports=" + Arrays.toString(this.ports) + ", target: " + this.target + ", username=" + this.username + "]";
    }
}

