/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.irc.IrcConfiguration;
import org.apache.camel.component.irc.IrcEndpoint;
import org.apache.camel.component.irc.IrcLogger;
import org.apache.camel.impl.DefaultComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCEventListener;
import org.schwering.irc.lib.ssl.SSLIRCConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IrcComponent
extends DefaultComponent {
    private static final transient Log LOG = LogFactory.getLog(IrcComponent.class);
    private final Map<String, IRCConnection> connectionCache = new HashMap<String, IRCConnection>();

    public IrcEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        IrcConfiguration config = new IrcConfiguration();
        config.configure(uri);
        IrcEndpoint endpoint = new IrcEndpoint(uri, this, config);
        this.setProperties(endpoint.getConfiguration(), parameters);
        return endpoint;
    }

    public synchronized IRCConnection getIRCConnection(IrcConfiguration configuration) {
        IRCConnection connection;
        if (this.connectionCache.containsKey(configuration.getCacheKey())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Returning Cached Connection to " + configuration.getHostname() + ":" + configuration.getNickname()));
            }
            connection = this.connectionCache.get(configuration.getCacheKey());
        } else {
            connection = this.createConnection(configuration);
            this.connectionCache.put(configuration.getCacheKey(), connection);
        }
        return connection;
    }

    protected IRCConnection createConnection(IrcConfiguration configuration) {
        IRCConnection conn = null;
        if (configuration.getUsingSSL()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating SSL Connection to " + configuration.getHostname() + " destination(s): " + configuration.getListOfChannels() + " nick: " + configuration.getNickname() + " user: " + configuration.getUsername()));
            }
            SSLIRCConnection sconn = new SSLIRCConnection(configuration.getHostname(), configuration.getPorts(), configuration.getPassword(), configuration.getNickname(), configuration.getUsername(), configuration.getRealname());
            sconn.addTrustManager(configuration.getTrustManager());
            conn = sconn;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating Connection to " + configuration.getHostname() + " destination(s): " + configuration.getListOfChannels() + " nick: " + configuration.getNickname() + " user: " + configuration.getUsername()));
            }
            conn = new IRCConnection(configuration.getHostname(), configuration.getPorts(), configuration.getPassword(), configuration.getNickname(), configuration.getUsername(), configuration.getRealname());
        }
        conn.setEncoding("UTF-8");
        conn.setColors(configuration.isColors());
        conn.setPong(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Adding IRC event logging listener");
            IRCEventListener ircLogger = this.createIrcLogger(configuration.getHostname());
            conn.addIRCEventListener(ircLogger);
        }
        try {
            conn.connect();
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        return conn;
    }

    public void closeConnection(String key, IRCConnection connection) {
        try {
            connection.doQuit();
            connection.close();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error during closing connection.", (Throwable)e);
        }
    }

    protected void doStop() throws Exception {
        HashMap<String, IRCConnection> map = new HashMap<String, IRCConnection>(this.connectionCache);
        this.connectionCache.clear();
        for (Map.Entry entry : map.entrySet()) {
            this.closeConnection((String)entry.getKey(), (IRCConnection)entry.getValue());
        }
        super.doStop();
    }

    protected IRCEventListener createIrcLogger(String hostname) {
        return new IrcLogger(LOG, hostname);
    }
}

