/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.irc.IrcEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.schwering.irc.lib.IRCConnection;

public class IrcProducer
extends DefaultProducer {
    public static final String[] COMMANDS = new String[]{"AWAY", "INVITE", "ISON", "JOIN", "KICK", "LIST", "NAMES", "PRIVMSG", "MODE", "NICK", "NOTICE", "PART", "PONG", "QUIT", "TOPIC", "WHO", "WHOIS", "WHOWAS", "USERHOST"};
    private static final transient Log LOG = LogFactory.getLog(IrcProducer.class);
    private IRCConnection connection;
    private IrcEndpoint endpoint;

    public IrcProducer(IrcEndpoint endpoint, IRCConnection connection) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.connection = connection;
    }

    public void process(Exchange exchange) throws Exception {
        String msg = (String)exchange.getIn().getBody(String.class);
        String targetChannel = (String)exchange.getIn().getHeader("irc.target", String.class);
        if (this.isMessageACommand(msg)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sending command: " + msg));
            }
            this.connection.send(msg);
        } else if (targetChannel != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sending to: " + targetChannel + " message: " + msg));
            }
            this.connection.doPrivmsg(targetChannel, msg);
        } else {
            for (String channel : this.endpoint.getConfiguration().getChannels()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Sending to: " + channel + " message: " + msg));
                }
                this.connection.doPrivmsg(channel, msg);
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        List<String> channels = this.endpoint.getConfiguration().getChannels();
        for (String channel : this.endpoint.getConfiguration().getChannels()) {
            List<String> keys;
            int ndx = channels.indexOf(channel);
            String key = null;
            if (ndx >= 0 && (keys = this.endpoint.getConfiguration().getKeys()).size() > 0 && ndx < keys.size()) {
                key = keys.get(ndx);
            }
            if (ObjectHelper.isNotEmpty(key)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Joining: " + channel + " using " + this.connection.getClass().getName() + " with key " + key));
                }
                this.connection.doJoin(channel, key);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Joining: " + channel + " using " + this.connection.getClass().getName()));
            }
            this.connection.doJoin(channel);
        }
    }

    protected void doStop() throws Exception {
        if (this.connection != null) {
            for (String channel : this.endpoint.getConfiguration().getChannels()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Parting: " + channel));
                }
                this.connection.doPart(channel);
            }
        }
        super.doStop();
    }

    protected boolean isMessageACommand(String msg) {
        for (String command : COMMANDS) {
            if (!msg.startsWith(command)) continue;
            return true;
        }
        return false;
    }
}

