/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.irc.IrcBinding;
import org.apache.camel.component.irc.IrcChannel;
import org.apache.camel.component.irc.IrcComponent;
import org.apache.camel.component.irc.IrcConfiguration;
import org.apache.camel.component.irc.IrcConsumer;
import org.apache.camel.component.irc.IrcMessage;
import org.apache.camel.component.irc.IrcProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="irc", syntax="irc:hostname:port", consumerClass=IrcConsumer.class, label="chat")
public class IrcEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(IrcEndpoint.class);
    @UriParam
    private IrcConfiguration configuration;
    private IrcBinding binding;
    private IrcComponent component;

    public IrcEndpoint(String endpointUri, IrcComponent component, IrcConfiguration configuration) {
        super(UnsafeUriCharactersEncoder.encode((String)endpointUri), (Component)component);
        this.component = component;
        this.configuration = configuration;
    }

    public boolean isSingleton() {
        return true;
    }

    public Exchange createExchange(ExchangePattern pattern) {
        DefaultExchange exchange = new DefaultExchange((Endpoint)this, pattern);
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        return exchange;
    }

    public Exchange createOnPrivmsgExchange(String target, IRCUser user, String msg) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("PRIVMSG", target, user, msg));
        return exchange;
    }

    public Exchange createOnNickExchange(IRCUser user, String newNick) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("NICK", user, newNick));
        return exchange;
    }

    public Exchange createOnQuitExchange(IRCUser user, String msg) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("QUIT", user, msg));
        return exchange;
    }

    public Exchange createOnJoinExchange(String channel, IRCUser user) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("JOIN", channel, user));
        return exchange;
    }

    public Exchange createOnKickExchange(String channel, IRCUser user, String whoWasKickedNick, String msg) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("KICK", channel, user, whoWasKickedNick, msg));
        return exchange;
    }

    public Exchange createOnModeExchange(String channel, IRCUser user, IRCModeParser modeParser) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("MODE", channel, user, modeParser.getLine()));
        return exchange;
    }

    public Exchange createOnPartExchange(String channel, IRCUser user, String msg) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("PART", channel, user, msg));
        return exchange;
    }

    public Exchange createOnReplyExchange(int num, String value, String msg) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("REPLY", num, value, msg));
        return exchange;
    }

    public Exchange createOnTopicExchange(String channel, IRCUser user, String topic) {
        DefaultExchange exchange = this.getExchange();
        exchange.setIn((Message)new IrcMessage("TOPIC", channel, user, topic));
        return exchange;
    }

    public IrcProducer createProducer() throws Exception {
        return new IrcProducer(this, this.component.getIRCConnection(this.configuration));
    }

    public IrcConsumer createConsumer(Processor processor) throws Exception {
        IrcConsumer answer = new IrcConsumer(this, processor, this.component.getIRCConnection(this.configuration));
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public IrcComponent getComponent() {
        return this.component;
    }

    public void setComponent(IrcComponent component) {
        this.component = component;
    }

    public IrcBinding getBinding() {
        if (this.binding == null) {
            this.binding = new IrcBinding();
        }
        return this.binding;
    }

    public void setBinding(IrcBinding binding) {
        this.binding = binding;
    }

    public IrcConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IrcConfiguration configuration) {
        this.configuration = configuration;
    }

    public void handleIrcError(int num, String msg) {
        if (433 == num) {
            this.handleNickInUse();
        }
    }

    private void handleNickInUse() {
        IRCConnection connection = this.component.getIRCConnection(this.configuration);
        String nick = connection.getNick() + "-";
        if (nick.endsWith("----")) {
            LOG.error("Unable to set nick: " + nick + " disconnecting");
        } else {
            LOG.warn("Unable to set nick: " + nick + " Retrying with " + nick + "-");
            connection.doNick(nick);
            this.joinChannels();
        }
    }

    private DefaultExchange getExchange() {
        DefaultExchange exchange = new DefaultExchange((Endpoint)this, this.getExchangePattern());
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        return exchange;
    }

    public void joinChannels() {
        for (IrcChannel channel : this.configuration.getChannels()) {
            this.joinChannel(channel);
        }
    }

    public void joinChannel(String name) {
        this.joinChannel(this.configuration.findChannel(name));
    }

    public void joinChannel(IrcChannel channel) {
        if (channel == null) {
            return;
        }
        IRCConnection connection = this.component.getIRCConnection(this.configuration);
        String chn = channel.getName();
        String key = channel.getKey();
        if (ObjectHelper.isNotEmpty((Object)key)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Joining: {} using {} with secret key", (Object)channel, (Object)connection.getClass().getName());
            }
            connection.doJoin(chn, key);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Joining: {} using {}", (Object)channel, (Object)connection.getClass().getName());
            }
            connection.doJoin(chn);
        }
    }
}

