/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import org.apache.commons.logging.Log;
import org.schwering.irc.lib.IRCEventAdapter;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCUser;

public class IrcLogger
extends IRCEventAdapter {
    private Log log;
    private String server;

    public IrcLogger(Log log, String server) {
        this.log = log;
        this.server = server;
    }

    public void onDisconnected() {
        this.log.info((Object)("Server: " + this.server + " - onDisconnected"));
    }

    public void onError(int num, String msg) {
        this.log.error((Object)("Server: " + this.server + " - onError num=" + num + " msg=\"" + msg + "\""));
    }

    public void onError(String msg) {
        this.log.error((Object)("Server: " + this.server + " - onError msg=\"" + msg + "\""));
    }

    public void onInvite(String chan, IRCUser user, String passiveNick) {
        this.log.debug((Object)("Server: " + this.server + " - onInvite chan=" + chan + " user=" + user + " passiveNick=" + passiveNick));
    }

    public void onJoin(String chan, IRCUser user) {
        this.log.debug((Object)("Server: " + this.server + " - onJoin chan=" + chan + " user=" + user));
    }

    public void onKick(String chan, IRCUser user, String passiveNick, String msg) {
        this.log.debug((Object)("Server: " + this.server + " - onKick chan=" + chan + " user=" + user + " passiveNick=" + passiveNick + " msg=\"" + msg + "\""));
    }

    public void onMode(String chan, IRCUser user, IRCModeParser ircModeParser) {
        this.log.info((Object)("Server: " + this.server + " - onMode chan=" + chan + " user=" + user + " ircModeParser=" + ircModeParser));
    }

    public void onMode(IRCUser user, String passiveNick, String mode) {
        this.log.info((Object)("Server: " + this.server + " - onMode user=" + user + " passiveNick=" + passiveNick + " mode=" + mode));
    }

    public void onNick(IRCUser user, String newNick) {
        this.log.debug((Object)("Server: " + this.server + " - onNick user=" + user + " newNick=" + newNick));
    }

    public void onNotice(String target, IRCUser user, String msg) {
        this.log.debug((Object)("Server: " + this.server + " - onNotice target=" + target + " user=" + user + " msg=\"" + msg + "\""));
    }

    public void onPart(String chan, IRCUser user, String msg) {
        this.log.debug((Object)("Server: " + this.server + " - onPart chan=" + chan + " user=" + user + " msg=\"" + msg + "\""));
    }

    public void onPing(String ping) {
        this.log.info((Object)("Server: " + this.server + " - onPing ping=" + ping));
    }

    public void onPrivmsg(String target, IRCUser user, String msg) {
        this.log.debug((Object)("Server: " + this.server + " - onPrivmsg target=" + target + " user=" + user + " msg=\"" + msg + "\""));
    }

    public void onQuit(IRCUser user, String msg) {
        this.log.debug((Object)("Server: " + this.server + " - onQuit user=" + user + " msg=\"" + msg + "\""));
    }

    public void onRegistered() {
        this.log.info((Object)("Server: " + this.server + " - onRegistered"));
    }

    public void onReply(int num, String value, String msg) {
        this.log.debug((Object)("Server: " + this.server + " - onReply num=" + num + " value=\"" + value + "\" msg=\"" + msg + "\""));
    }

    public void onTopic(String chan, IRCUser user, String topic) {
        this.log.debug((Object)("Server: " + this.server + " - onTopic chan=" + chan + " user=" + user + " topic=" + topic));
    }

    public void unknown(String prefix, String command, String middle, String trailing) {
        this.log.info((Object)("Server: " + this.server + " - unknown prefix=" + prefix + " command=" + command + " middle=" + middle + " trailing=" + trailing));
    }
}

