/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iota;

import java.util.ArrayList;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.iota.IOTAEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.commons.lang3.StringUtils;
import org.iota.jota.builder.AddressRequest;
import org.iota.jota.dto.response.GetNewAddressResponse;
import org.iota.jota.dto.response.GetTransferResponse;
import org.iota.jota.dto.response.SendTransferResponse;
import org.iota.jota.model.Transfer;
import org.iota.jota.utils.TrytesConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOTAProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(IOTAProducer.class);
    private IOTAEndpoint endpoint;

    public IOTAProducer(IOTAEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        String seed = (String)exchange.getIn().getHeader("CamelIOTASeed", String.class);
        if (this.endpoint.getOperation() == null) {
            throw new UnsupportedOperationException("IOTAProducer operation cannot be null!");
        }
        if (this.endpoint.getOperation().equals("sendTransfer")) {
            String address = (String)exchange.getIn().getHeader("CamelIOTAToAddress", String.class);
            Integer value = (Integer)exchange.getIn().getHeader("CamelIOTAValue", Integer.class);
            value = value != null ? value : 0;
            String tag = StringUtils.rightPad((String)this.endpoint.getTag(), (int)27, (char)'9');
            String message = TrytesConverter.asciiToTrytes((String)((String)exchange.getIn().getBody(String.class)));
            if (LOG.isDebugEnabled()) {
                LOG.debug("endpoint: security level {} depth {} minWeightMagnitude {} tag {} ", new Object[]{this.endpoint.getSecurityLevel(), this.endpoint.getDepth(), this.endpoint.getMinWeightMagnitude(), tag});
                LOG.debug("Sending value {} with message {} to address {}", new Object[]{value, message, address});
            }
            ArrayList<Transfer> transfers = new ArrayList<Transfer>();
            transfers.add(new Transfer(address, (long)value.intValue(), message, tag));
            SendTransferResponse response = this.endpoint.getApiClient().sendTransfer(seed, this.endpoint.getSecurityLevel().intValue(), this.endpoint.getDepth().intValue(), this.endpoint.getMinWeightMagnitude().intValue(), transfers, null, null, false, true, null);
            exchange.getIn().setBody((Object)response.getTransactions());
        } else if (this.endpoint.getOperation().equals("getNewAddress")) {
            Integer index = (Integer)exchange.getIn().getHeader("CamelIOTAAddressIndex", Integer.class);
            AddressRequest addressRequest = new AddressRequest.Builder(seed, this.endpoint.getSecurityLevel().intValue()).index(index.intValue()).checksum(true).amount(1).build();
            GetNewAddressResponse response = this.endpoint.getApiClient().generateNewAddresses(addressRequest);
            exchange.getIn().setBody((Object)response.getAddresses());
        } else if (this.endpoint.getOperation().equals("getTransfers")) {
            Integer startIdx = (Integer)exchange.getIn().getHeader("CamelIOTAAddressStartIndex", Integer.class);
            Integer endIdx = (Integer)exchange.getIn().getHeader("CamelIOTAAddressEndIndex", Integer.class);
            GetTransferResponse response = this.endpoint.getApiClient().getTransfers(seed, this.endpoint.getSecurityLevel().intValue(), startIdx, endIdx, Boolean.valueOf(true));
            exchange.getIn().setBody((Object)response.getTransfers());
        }
    }
}

