/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import java.util.function.Supplier;
import org.apache.camel.Service;
import org.apache.camel.component.infinispan.InfinispanAggregationRepository;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteManager;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteUtil;
import org.apache.camel.component.infinispan.remote.protostream.DefaultExchangeHolderContextInitializer;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultExchangeHolder;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.function.Suppliers;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.protostream.SerializationContextInitializer;

@Metadata(label="bean", description="Aggregation repository that uses remote Infinispan to store exchanges.", annotations={"interfaceName=org.apache.camel.spi.AggregationRepository"})
@Configurer(metadataOnly=true)
public class InfinispanRemoteAggregationRepository
extends InfinispanAggregationRepository {
    private Supplier<BasicCache<String, DefaultExchangeHolder>> cache;
    private InfinispanRemoteManager manager;
    @Metadata(description="Name of cache", required=true)
    private String cacheName;
    @Metadata(description="Configuration for remote Infinispan")
    private InfinispanRemoteConfiguration configuration;
    @Metadata(description="Whether or not recovery is enabled", defaultValue="true")
    private boolean useRecovery = true;
    @Metadata(description="Sets an optional dead letter channel which exhausted recovered Exchange should be send to.")
    private String deadLetterUri;
    @Metadata(description="Sets the interval between recovery scans", defaultValue="5000")
    private long recoveryInterval = 5000L;
    @Metadata(description="Sets an optional limit of the number of redelivery attempt of recovered Exchange should be attempted, before its exhausted. When this limit is hit, then the Exchange is moved to the dead letter channel.", defaultValue="3")
    private int maximumRedeliveries = 3;
    @Metadata(label="advanced", description="Whether headers on the Exchange that are Java objects and Serializable should be included and saved to the repository")
    private boolean allowSerializedHeaders;

    public InfinispanRemoteAggregationRepository() {
    }

    public InfinispanRemoteAggregationRepository(String cacheName) {
        super(cacheName);
    }

    protected void doStart() throws Exception {
        InfinispanRemoteConfiguration conf;
        super.doStart();
        InfinispanRemoteConfiguration infinispanRemoteConfiguration = conf = this.configuration != null ? this.configuration : new InfinispanRemoteConfiguration();
        if (conf.getCacheContainerConfiguration() == null) {
            conf.setCacheContainerConfiguration(new ConfigurationBuilder().addContextInitializer((SerializationContextInitializer)new DefaultExchangeHolderContextInitializer()).build());
        } else {
            conf.setCacheContainerConfiguration(new ConfigurationBuilder().read(conf.getCacheContainerConfiguration(), Combine.DEFAULT).addContextInitializer((SerializationContextInitializer)new DefaultExchangeHolderContextInitializer()).build());
        }
        this.manager = new InfinispanRemoteManager(conf);
        this.manager.setCamelContext(this.getCamelContext());
        this.cache = Suppliers.memorize(() -> InfinispanRemoteUtil.getCacheWithFlags(this.manager, this.getCacheName(), Flag.FORCE_RETURN_VALUE));
        ServiceHelper.startService((Service)this.manager);
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Service)this.manager);
    }

    protected BasicCache<String, DefaultExchangeHolder> getCache() {
        return this.cache.get();
    }

    public InfinispanRemoteConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(InfinispanRemoteConfiguration configuration) {
        this.configuration = configuration;
    }
}

