/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.embedded;

import java.util.function.Supplier;
import org.apache.camel.Service;
import org.apache.camel.ShutdownableService;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.infinispan.InfinispanIdempotentRepository;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedConfiguration;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedManager;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.Suppliers;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.manager.EmbeddedCacheManager;

@Metadata(label="bean", description="Idempotent repository that uses embedded Infinispan to store message ids.", annotations={"interfaceName=org.apache.camel.spi.IdempotentRepository"})
@Configurer(metadataOnly=true)
@ManagedResource(description="Infinispan Embedded message id repository")
public class InfinispanEmbeddedIdempotentRepository
extends InfinispanIdempotentRepository {
    private Supplier<BasicCache<String, Boolean>> cache;
    private InfinispanEmbeddedManager manager;
    @Metadata(description="Name of cache", required=true)
    private String cacheName;
    @Metadata(description="Configuration for embedded Infinispan")
    private InfinispanEmbeddedConfiguration configuration;

    public InfinispanEmbeddedIdempotentRepository() {
    }

    public InfinispanEmbeddedIdempotentRepository(String cacheName) {
        this.cacheName = cacheName;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ObjectHelper.notNull((Object)this.cacheName, (String)"cacheName", (Object)((Object)this));
        if (this.configuration == null) {
            this.configuration = new InfinispanEmbeddedConfiguration();
        }
        this.manager = new InfinispanEmbeddedManager(this.configuration);
        this.manager.setCamelContext(this.getCamelContext());
        this.cache = Suppliers.memorize(() -> this.manager.getCache(this.getCacheName()));
        ServiceHelper.startService((Service)this.manager);
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService((ShutdownableService)this.manager);
        super.doShutdown();
    }

    protected BasicCache<String, Boolean> getCache() {
        return this.cache.get();
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public InfinispanEmbeddedConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(InfinispanEmbeddedConfiguration configuration) {
        this.configuration = configuration;
    }

    public InfinispanEmbeddedManager getManager() {
        return this.manager;
    }

    public void setManager(InfinispanEmbeddedManager manager) {
        this.manager = manager;
    }

    public EmbeddedCacheManager getCacheContainer() {
        return this.configuration != null ? this.configuration.getCacheContainer() : null;
    }

    public void setCacheContainer(EmbeddedCacheManager cacheContainer) {
        if (this.configuration == null) {
            this.configuration = new InfinispanEmbeddedConfiguration();
        }
        this.configuration.setCacheContainer(cacheContainer);
    }
}

